<?php namespace App\Controllers\Administrativo;

 use App\Models\Administrativo\TransportesModel;
 use CodeIgniter\Controller;
 use App\Libraries\Auth;
 
 class Transportes extends Controller
 {

	public function __construct(){
        $this->session = \Config\Services::session();
        $this->usuario = $this->session->get('dadoslogin');
        if($this->usuario == null){
            header('Location: '.base_url());
            exit(); 
        }
        $this->transportesModel = new TransportesModel();
        $this->auth = new Auth();
        helper('complementos'); 
	}

	public function transportesConsultar(){
        if($this->auth->CheckAuth(21)){
            $dados['resultados'] = $this->transportesModel->getTransportes();
            echo view('Commons/header');	
            echo view('Commons/navbartop');
            echo view('Commons/navbarleft', getBarMenu($this->usuario));
            echo view('Administrativo/Transportes/transportes', $dados);
            echo view('Commons/footer');
        }else{
            return redirect()->to('/Acesso');
        }
	}

    public function transportesEditar($id=""){
        if($this->auth->CheckAuth(23)){
            $dados['transporte'] = $this->transportesModel->getTransportesID(base64_decode($id));
            echo view('Commons/header');
            echo view('Commons/navbartop');
            echo view('Commons/navbarleft', getBarMenu($this->usuario));
            echo view('Administrativo/Transportes/cad_transportes', $dados);
            echo view('Commons/footer');
        }else{
            return redirect()->to('/Acesso');
        }
    }
    
    public function transportesExcluir($id=""){
        if($this->auth->CheckAuth(24)){
            $this->transportesModel->modelidadesDeletar(base64_decode($id));
            return redirect()->to('/Administrativo/Transportes/transportesConsultar?tipo_msg=sucesso&msg=Ação realizada!');
        }else{
            return redirect()->to('/Acesso');
        }
    }
        
    public function transportesInserir(){
        if($this->auth->CheckAuth(22)){
            $dados = array();
            $id = $this->request->getPost('id_transporte');
            if($id == ""){
                $dados['NOME_TRANSPORTE'] = $this->request->getPost('nome_transporte');
                /* $dados['USUARIO'] = $this->request->getPost('usuario_login');
                $dados['SENHA'] = sha1(preg_replace('/[^[:alnum:]_]/', '',$this->request->getPost('usuario_senha'))); 
                $dados['EMAIL'] = $this->request->getPost('usuario_email');
                $dados['TELEFONE'] = $this->request->getPost('usuario_telefone');
                $dados['ATIVO'] = $this->request->getPost('usuario_status');*/
                
                if($this->transportesModel->setTransportes($dados)){
                    return redirect()->to('/Administrativo/Transportes/transportesConsultar?tipo_msg=sucesso&msg=Ação realizada!');
                }else{
                    return redirect()->to('/Administrativo/Transportes/transportesConsultar?tipo_msg=erro&msg=Erro ao realizar ação!');
                }
            }else{
                $dados['ID_TRANSPORTE'] = $this->request->getPost('id_transporte');
                $dados['NOME_TRANSPORTE'] = $this->request->getPost('nome_transporte');
                
                /* $dados['NOME'] = $this->request->getPost('usuario_nome');
                $dados['USUARIO'] = $this->request->getPost('usuario_login');
                $dados['EMAIL'] = $this->request->getPost('usuario_email');
                $dados['TELEFONE'] = $this->request->getPost('usuario_telefone');
                $dados['ATIVO'] = $this->request->getPost('usuario_status');*/

                if($this->transportesModel->updateTransportes($dados)){
                    
                    return redirect()->to('/Administrativo/Transportes/transportesConsultar?tipo_msg=sucesso&msg=Ação realizada!');
                }else{
                    return redirect()->to('/Administrativo/Transportes/transportesConsultar?tipo_msg=erro&msg=Erro ao realizar ação!');
                }
            }
        }else{
            return redirect()->to('/Acesso');
        }
    } 
}
