<?php namespace App\Models\Administrativo;

use CodeIgniter\Model;

class IpagamentosModel extends Model{

    public function __construct(){
        $this->db      = \Config\Database::connect();
        $this->builder = $this->db->table('CAD_IPAGAMENTOS');
        $this->session = \Config\Services::session();
        $this->usuario = $this->session->get('dadoslogin');
    }

    function getIpagamentos(){
        return $this->builder->get();
    }

    function getIpagamentosID($id){
        $this->builder->where('ID_IPAGAMENTO', $id);
        //return $builder->get()->getRow();
        return $this->builder->get()->getRow();
    }

    function setIpagamentos($dados){
        $builder = $this->db->table('CAD_IPAGAMENTOS');
        $builder->insert($dados);
        $id = $this->db->insertID();
        sys_log($this->usuario['ID_USUARIO'], "Inserção de dados ID: ".$id."", "CAD_IPAGAMENTOS");
        return $id;
    }

    function updateIpagamentos($dados){
        $builder = $this->db->table('CAD_IPAGAMENTOS');
        $builder->where('ID_IPAGAMENTO', $dados['ID_IPAGAMENTO']);
        $builder->update($dados);
        sys_log($this->usuario['ID_USUARIO'], "Atualização de dados ID: ".$dados['ID_IPAGAMENTO']."", "CAD_IPAGAMENTOS");
        return $this->db->affectedRows();
    }

    function modelidadesDeletar($idcategoria){   
        $this->builder->where('ID_IPAGAMENTO', $idcategoria);
        $this->builder->where('ID_IPAGAMENTO', $idcategoria)->delete();  
        
    }

    
}
?>