/* Funções da tabela Configuracoes/Funcionario */
window.onload = function () {
  var base_url = window.location.origin + "/";
  var table = $('#perfis').DataTable({
    "language": {
      "sEmptyTable": "Nenhum registro encontrado",
      "sInfo": "Mostrando de _START_ até _END_ de _TOTAL_ registros",
      "sInfoEmpty": "Mostrando 0 até 0 de 0 registros",
      "sInfoFiltered": "(Filtrados de _MAX_ registros)",
      "sInfoPostFix": "",
      "sInfoThousands": ".",
      "sLengthMenu": "_MENU_ resultados por página",
      "sLoadingRecords": "Carregando...",
      "sProcessing": "Processando...",
      "sZeroRecords": "Nenhum registro encontrado",
      "sSearch": "Pesquisar",
      "oPaginate": {
        "sNext": "Próximo",
        "sPrevious": "Anterior",
        "sFirst": "Primeiro",
        "sLast": "Último"
      },
      "oAria": {
        "sSortAscending": ": Ordenar colunas de forma ascendente",
        "sSortDescending": ": Ordenar colunas de forma descendente"
      }
    },
    scrollX: true,
    pageLength: 100
  });

  $('#perfis tbody').on('click', 'tr', function () {
    $(this).toggleClass('selected');
  });

  /** Limpa e gera pesquisa */
  $('#limpafrmpesquisa').click(function () {
    $("#frm_pesquisa")[0].reset();
    $('#frm_pesquisa input').val(""); //coloca todos valores de todos inputs do form como vazio
    $(":checkbox").prop('checked', false);
    $(':checkbox').find('checked').remove();
  });
  $('#enviafrmpesquisa').click(function () {
    $("#frm_pesquisa")[0].submit();
  });

  $("#perfis button").click(function () {
    var classe = $(this).attr('class');
    if (classe == "btn bg-red btn-list-icon") {
      var id = $(this).attr('id');
      swal({
        title: "Deseja excluir?",
        text: "Ao excluir, o mesmo será removido permanentemente",
        type: "warning",
        showCancelButton: true,
        confirmButtonColor: "#1E9FF2",
        confirmButtonText: "Sim, pode excluir!",
        cancelButtonText: "Não, cancele!",
        closeOnConfirm: true,
        closeOnCancel: false
      }, function (isConfirm) {
        if (isConfirm) {
          window.location.replace(base_url + "Configuracoes/Perfil/perfilExcluir/" + id);
        } else {
          swal("Cancelado", "Operação cancelada!", "error");
        }
      });
    }

  });

  /** MARCAR TODAS AS CHECKBOX -> PERMISSOES */
  $("#permissoes_chk_all").click(function () {
    if ($('#permissoes_chk_all').prop('checked')) {
      $('.checkboxes').each(function (index) {
        $(this).attr("checked", true);
        $(this).parents('span').addClass("checked");
      });
    } else {
      $('.checkboxes').each(function () {
        $(this).attr("checked", false);
        $(this).parents('span').removeClass("checked");
      });
    }

  });

  /** Verifica antes de salvar as permissoes */
  $('#gravar_permissoes').click(function () {
    swal({
      title: "Deseja salvar?",
      text: "Certifique-se de ter verificado todos os dados antes de efetuar a ação!",
      type: "warning",
      showCancelButton: true,
      confirmButtonColor: "#1E9FF2",
      confirmButtonText: "Sim, pode salvar!",
      cancelButtonText: "Não, cancele!",
      closeOnConfirm: true,
      closeOnCancel: false
    }, function (isConfirm) {
      if (isConfirm) {
        $('#frmPermissoes').submit();
      } else {
        swal("Cancelado", "Operação cancelada! Dados não gravados", "error");
      }
    });
  });

  if ($('#perfil_id').val() != "") {
    var id = $('#perfil_id').val();
    $.ajax({
      type: "POST",
      url: base_url + 'Configuracoes/Perfil/perfilConsultarPermissoes',
      data: {
        'id': id,
        csrf_token: $('#crsf_token').val()
      },
      dataType: 'json',
      success: function (data) {
        if (data.length > 0) {
          var x = 0;
          for (x = 0; x < data.length; x++) {
            $('.checkboxes').each(function (index) {
              if ($(this).val() == data[x].FK_ID_METODO) {
                $(this).attr("checked", true);
                $(this).parents('span').addClass("checked");
              }
            });
          }
        }
      }
    });
  }
};
