<?php namespace App\Controllers\Administrativo;

 use App\Models\Administrativo\IpagamentosModel;
 use CodeIgniter\Controller;
 use App\Libraries\Auth;
 
 class Ipagamentos extends Controller
 {

	public function __construct(){
        $this->session = \Config\Services::session();
        $this->usuario = $this->session->get('dadoslogin');
        if($this->usuario == null){
            header('Location: '.base_url());
            exit(); 
        }
        $this->ipagamentosModel = new IpagamentosModel();
        $this->auth = new Auth();
        helper('complementos'); 
	}

	public function ipagamentosConsultar(){
        if($this->auth->CheckAuth(9)){
        $dados['resultados'] = $this->ipagamentosModel->getIpagamentos();
        echo view('Commons/header');	
        echo view('Commons/navbartop');
        echo view('Commons/navbarleft', getBarMenu($this->usuario));
        echo view('Administrativo/Ipagamentos/ipagamentos', $dados);
        echo view('Commons/footer');
        }else{
            return redirect()->to('/Acesso');
        }
	}

    public function ipagamentosEditar($id=""){
        if($this->auth->CheckAuth(11)){
            $dados['ipagamento'] = $this->ipagamentosModel->getIpagamentosID(base64_decode($id));
            echo view('Commons/header');
            echo view('Commons/navbartop');
            echo view('Commons/navbarleft', getBarMenu($this->usuario));
            echo view('Administrativo/Ipagamentos/cad_ipagamentos', $dados);
            echo view('Commons/footer');
        }else{
            return redirect()->to('/Acesso');
        }
    }
    
            public function ipagamentosExcluir($id=""){
                if($this->auth->CheckAuth(12)){
                $this->ipagamentosModel->modelidadesDeletar(base64_decode($id));
                return redirect()->to('/Administrativo/Ipagamentos/ipagamentosConsultar?tipo_msg=sucesso&msg=Ação realizada!');
                                                }
            }
        
            public function ipagamentosInserir(){
                if($this->auth->CheckAuth(10)){
                $dados = array();
                $id = $this->request->getPost('id_ipagamento');
                if($id == ""){
                    $dados['NOME_IPAGAMENTO'] = $this->request->getPost('nome_ipagamento');
                   /* $dados['USUARIO'] = $this->request->getPost('usuario_login');
                    $dados['SENHA'] = sha1(preg_replace('/[^[:alnum:]_]/', '',$this->request->getPost('usuario_senha'))); 
                    $dados['EMAIL'] = $this->request->getPost('usuario_email');
                    $dados['TELEFONE'] = $this->request->getPost('usuario_telefone');
                    $dados['ATIVO'] = $this->request->getPost('usuario_status');*/
                    
                    if($this->ipagamentosModel->setIpagamentos($dados)){
                       
                        return redirect()->to('/Administrativo/Ipagamentos/ipagamentosConsultar?tipo_msg=sucesso&msg=Ação realizada!');
                    }else{
                        return redirect()->to('/Administrativo/Ipagamentos/ipagamentosConsultar?tipo_msg=erro&msg=Erro ao realizar ação!');
                    }
                }else{
                    $dados['ID_IPAGAMENTO'] = $this->request->getPost('id_ipagamento');
                    $dados['NOME_IPAGAMENTO'] = $this->request->getPost('nome_ipagamento');
                    
                   /* $dados['NOME'] = $this->request->getPost('usuario_nome');
                    $dados['USUARIO'] = $this->request->getPost('usuario_login');
                    $dados['EMAIL'] = $this->request->getPost('usuario_email');
                    $dados['TELEFONE'] = $this->request->getPost('usuario_telefone');
                    $dados['ATIVO'] = $this->request->getPost('usuario_status');*/
        
                    
                    
                    if($this->ipagamentosModel->updateIpagamentos($dados)){
                       
                        return redirect()->to('/Administrativo/Ipagamentos/ipagamentosConsultar?tipo_msg=sucesso&msg=Ação realizada!');
                    }else{
                        return redirect()->to('/Administrativo/Ipagamentos/ipagamentosConsultar?tipo_msg=erro&msg=Erro ao realizar ação!');
                    }
                }
                    }
            }

        
        
        
        
}
