<?php namespace App\Models\Administrativo;

use CodeIgniter\Model;

class ProdutoModel extends Model{

    public function __construct(){
        $this->db      = \Config\Database::connect();
        $this->builder = $this->db->table('CAD_PRODUTO');
        $this->session = \Config\Services::session();
        $this->usuario = $this->session->get('dadoslogin');
    }

    function getProduto(){
        return $this->builder->get();
        
    }

    function getProdutoID($id){
        $this->builder->where('ID_PRODUTO', $id);
        //return $builder->get()->getRow();
        return $this->builder->get()->getRow();
    }

    function updateProduto($dados){
        $builder = $this->db->table('CAD_PRODUTO');
        $builder->where('ID_PRODUTO', $dados['ID_PRODUTO']);
        $builder->update($dados);
        sys_log($this->usuario['ID_USUARIO'], "Atualização de dados ID: ".$dados['ID_PRODUTO']."", "CAD_PRODUTO");
        return $this->db->affectedRows();
    }

    function produtoDeletar($idproduto){   
        $this->builder->where('ID_PRODUTO', $idproduto);
        $resultado = $this->builder->get()->getRow();
        $caminho = $resultado->CAMINHO_IMAGEM;
        $this->builder->where('ID_PRODUTO', $idproduto)->delete();  
        $path_to_file = '.'.$caminho;
        if ($caminho!="/images/"){
            if(unlink($path_to_file)) {
                echo 'deleted successfully';
            }else{
    
                 }


        }  
    }

    function setProduto($dados){
        $builder = $this->db->table('CAD_PRODUTO');
        $builder->insert($dados);
        $id = $this->db->insertID();
        sys_log($this->usuario['ID_USUARIO'], "Inserção de dados ID: ".$id."", "CAD_PRODUTOS");
        return $id;
    }

    
}
?>