<?php namespace App\Controllers\Administrativo;

 use App\Models\Administrativo\ArmazensModel;
 use CodeIgniter\Controller;
 use App\Libraries\Auth;
 
 class Armazens extends Controller
 {

	public function __construct(){
        $this->session = \Config\Services::session();
        $this->usuario = $this->session->get('dadoslogin');
        if($this->usuario == null){
            header('Location: '.base_url());
            exit(); 
        }
        $this->armazensModel = new ArmazensModel();
        $this->auth = new Auth();
        helper('complementos'); 
	}

    public function index(){

        echo view ("Administrativo/Armazens/armazens");
    }
    public function armazensConsultar(){
        if($this->auth->CheckAuth(13)){
        $dados['resultados'] = $this->armazensModel->getArmazens();
        echo view('Commons/header');	
        echo view('Commons/navbartop');
        echo view('Commons/navbarleft', getBarMenu($this->usuario));
        echo view('Administrativo/Armazens/armazens', $dados);
        echo view('Commons/footer');
        }else{
            return redirect()->to('/Acesso');
        }
	}
    public function armazensImprimir($id=""){
        if($this->auth->CheckAuth(13)){
            $dados['armazem'] = $this->armazensModel->getArmazensID(base64_decode($id));
             //$result = $this->contratosModel->contratosImprimir(base64_decode($id));;
            echo view('Administrativo/Armazens/imp_armazem', $dados);
            //echo $result->ID_CONTRATO;
        }else{
            return redirect()->to('/Acesso');
        }
    }
    public function armazensEditar($id=""){
        if($this->auth->CheckAuth(15)){
            $dados['armazem'] = $this->armazensModel->getArmazensID(base64_decode($id));
            echo view('Commons/header');
            echo view('Commons/navbartop');
            echo view('Commons/navbarleft', getBarMenu($this->usuario));
            echo view('Administrativo/Armazens/cad_armazens', $dados);
            echo view('Commons/footer');
        }else{
            return redirect()->to('/Acesso');
        }
    }

    public function armazensInserir(){
        if($this->auth->CheckAuth(14)){
            $dados = array();
            $id = $this->request->getPost('id_armazem');
            if($id == ""){
               
                $dados['NOME_ARMAZEM'] = $this->request->getPost('nome_armazem');
                    $dados['DOCUMENTO_ARMAZEM'] = $this->request->getPost('documento_armazem');
                    $dados['IE_ARMAZEM'] = $this->request->getPost('ie_armazem');
                    $dados['TELEFONE_ARMAZEM'] = $this->request->getPost('telefone_armazem');
                    $dados['ENDERECO_ARMAZEM'] = $this->request->getPost('endereco_armazem');
                    $dados['BAIRRO_ARMAZEM'] = $this->request->getPost('bairro_armazem');
                    $dados['CEP_ARMAZEM'] = $this->request->getPost('cep_armazem');
                    $dados['CIDADE_ARMAZEM'] = $this->request->getPost('cidade_armazem');
                    $dados['ESTADO_ARMAZEM'] = $this->request->getPost('estado_armazem');
                if($this->armazensModel->setArmazens($dados)){
                    
                 return redirect()->to('/Administrativo/Armazens/armazensConsultar?tipo_msg=sucesso&msg=Ação realizada!');
                    
                }else{
                    return redirect()->to('/Administrativo/Armazens/armazensConsultar?tipo_msg=erro&msg=Erro ao realizar ação!');
                }
            }else{
                $dados['ID_ARMAZEM'] = $this->request->getPost('id_armazem');
                $dados['NOME_ARMAZEM'] = $this->request->getPost('nome_armazem');
                $dados['DOCUMENTO_ARMAZEM'] = $this->request->getPost('documento_armazem');
                $dados['IE_ARMAZEM'] = $this->request->getPost('ie_armazem');
                $dados['TELEFONE_ARMAZEM'] = $this->request->getPost('telefone_armazem');
                $dados['ENDERECO_ARMAZEM'] = $this->request->getPost('endereco_armazem');
                $dados['BAIRRO_ARMAZEM'] = $this->request->getPost('bairro_armazem');
                $dados['CEP_ARMAZEM'] = $this->request->getPost('cep_armazem');
                $dados['CIDADE_ARMAZEM'] = $this->request->getPost('cidade_armazem');
                $dados['ESTADO_ARMAZEM'] = $this->request->getPost('estado_armazem');
               /* $dados['NOME'] = $this->request->getPost('usuario_nome');
                $dados['USUARIO'] = $this->request->getPost('usuario_login');
                $dados['EMAIL'] = $this->request->getPost('usuario_email');
                $dados['TELEFONE'] = $this->request->getPost('usuario_telefone');
                $dados['ATIVO'] = $this->request->getPost('usuario_status');*/
    
                
                
                if($this->armazensModel->updateArmazens($dados)){
                  
                   return redirect()->to('/Administrativo/Armazens/armazensConsultar?tipo_msg=sucesso&msg=Ação realizada!');
                    
                }else{
                    return redirect()->to('/Administrativo/Armazens/armazensConsultar?tipo_msg=erro&msg=Erro ao realizar ação!');
                }
            }
        }else{
            return redirect()->to('/Acesso');
        }
    }

    public function armazensExcluir($id=""){
        if($this->auth->CheckAuth(16)){
        $this->armazensModel->deletarArmazens(base64_decode($id));
        return redirect()->to('/Administrativo/Armazens/armazensConsultar?tipo_msg=sucesso&msg=Ação realizada!');
                                        }else{
                                            return redirect()->to('/Acesso');
                                        }
    }

    public function armazensVerificar(){
        $documento = $this->request->getPost('documento');
        $resultado = $this->armazensModel->armazensVerificar($documento);
        echo json_encode($this->armazensModel->armazensVerificar($documento));
        //echo ($documento);
        //echo json_encode($this->pessoasModel->pessoasVerificar($this->request->getPost('documento')));
    }
        
        
}
