var base_url = window.location.origin + "/";

$('.datafmtbr').inputmask('99/99/9999');
$('.datafmtbr').datepicker({
  autoclose: true,
  format: 'dd.mm.yyyy',
  language: 'pt-BR'
});
$('.datafmtnf').inputmask('99/9999');
$('.datafmtnf').datepicker({
  autoclose: true,
  format: 'mm.yyyy',
  language: 'pt-BR'
});

$('.data').inputmask('99/99/9999');
$('.horafmtbr').inputmask('99:99');


$('.competencia').inputmask('99/9999');

$('.mac').inputmask('##:##:##:##:##:##');
$('.ip').inputmask('999.999.999.999');
$('.cpf').inputmask('999.999.999-99');
$('.cnpj').inputmask('99.999.999/9999-99');
$('.cep').inputmask('99999-999');
$('.placa').inputmask('AAA-9999');

$('.telefone').inputmask('(99)99999-9999');
$('.percentual').inputmask('99.99');

$('.dinheiro').maskMoney({

  prefix: 'R$ ',

  allowNegative: true,

  thousands: '',

  decimal: ',',

  affixesStay: false

});
$('.metragem').maskMoney({

  prefix: '',

  allowNegative: true,

  thousands: '',

  decimal: '.',

  affixesStay: false

});

function GetURLParameter(sParam) {
  var sPageURL = window.location.search.substring(1);
  var sURLVariables = sPageURL.split('&');
  for (var i = 0; i < sURLVariables.length; i++) {
    var sParameterName = sURLVariables[i].split('=');
    if (sParameterName[0] == sParam) {
      return sParameterName[1];
    }
  }
}​

/**CSS VALIDATION FORM */

$('.validate').validate({
  errorElement: 'span', //default input error message container
  errorClass: 'help-block help-block-error', // default input error message class
  focusInvalid: false, // do not focus the last invalid input
  ignore: "", // validate all fields including form hidden input
  messages: {
    select_multi: {
      maxlength: jQuery.validator.format("Max {0} items allowed for selection"),
      minlength: jQuery.validator.format("At least {0} items must be selected")
    }
  },

  highlight: function (element) { // hightlight error inputs
    $(element)
      .closest('.form-group').addClass('has-error'); // set error class to the control group
  },

  unhighlight: function (element) { // revert the change done by hightlight
    $(element)
      .closest('.form-group').removeClass('has-error'); // set error class to the control group
  },

  success: function (label) {
    label
      .closest('.form-group').removeClass('has-error'); // set success class to the control group
  },
});

/** Data atual */
function dataAtual() {
  var d = new Date();

  var month = d.getMonth() + 1;
  var day = d.getDate();

  var output = (('' + day).length < 2 ? '0' : '') + day +
    '/' + (('' + month).length < 2 ? '0' : '') + month + '/' +
    d.getFullYear();
  return output;
}

function dataValidaBoleto(dt) {
  var strData = dt;
  var partesData = strData.split("/");
  var data = new Date(partesData[2], partesData[1] - 1, partesData[0]);
  if (dt == dataAtual()) {
    return true;
  } else {
    if (data > new Date()) {
      return true;
    } else {
      return false;
    }
  }
}

/** Validações */
function valData(data) { //dd/mm/aaaa
  day = data.substring(0, 2);
  month = data.substring(3, 5);
  year = data.substring(6, 10);

  if ((month == 01) || (month == 03) || (month == 05) || (month == 07) || (month == 08) || (month == 10) || (month == 12)) { //mes com 31 dias
    if ((day < 01) || (day > 31)) {
      return false;
    } else {
      return true;
    }
  } else

  if ((month == 04) || (month == 06) || (month == 09) || (month == 11)) { //mes com 30 dias
    if ((day < 01) || (day > 30)) {
      return false;
    } else {
      return true;
    }
  } else

  if ((month == 02)) { //February and leap year
    if ((year % 4 == 0) && ((year % 100 != 0) || (year % 400 == 0))) {
      if ((day < 01) || (day > 29)) {
        return false;
      } else {
        return true;
      }
    } else {
      if ((day < 01) || (day > 28)) {
        return false;
      } else {
        return true;
      }
    }
  }
}
