<?php namespace App\Controllers\Administrativo;

 use App\Models\Administrativo\PessoasModel;
 use App\Models\Administrativo\IpagamentosModel;
 use CodeIgniter\Controller;
 use App\Libraries\Auth;
 
 class Pessoas extends Controller
 {

	public function __construct(){
        $this->session = \Config\Services::session();
        $this->usuario = $this->session->get('dadoslogin');
        if($this->usuario == null){
            header('Location: '.base_url());
            exit(); 
        }
        $this->pessoasModel = new PessoasModel();
        $this->ipagamentosModel = new IpagamentosModel();
        $this->auth = new Auth();
        helper('complementos'); 
	}

	public function pessoasConsultar(){
        if($this->auth->CheckAuth(9)){
            $dados['resultados'] = $this->pessoasModel->getPessoas();
            echo view('Commons/header');	
            echo view('Commons/navbartop');
            echo view('Commons/navbarleft', getBarMenu($this->usuario));
            echo view('Administrativo/Pessoas/pessoas', $dados);
            echo view('Commons/footer');
        }else{
            return redirect()->to('/Acesso');
        }
	}
    public function pessoasImprimir($id=""){
        if($this->auth->CheckAuth(9)){
            $dados['pessoa'] = $this->pessoasModel->getPessoasID(base64_decode($id));
             //$result = $this->contratosModel->contratosImprimir(base64_decode($id));;
            echo view('Administrativo/Pessoas/imp_pessoas', $dados);
            //echo $result->ID_CONTRATO;
        }else{
            return redirect()->to('/Acesso');
        }
    }

    public function pessoasEditar($id=""){
        if($this->auth->CheckAuth(11)){
            $dados['pessoa'] = $this->pessoasModel->getPessoasID(base64_decode($id));
            $dados['ipagamentos'] = $this->ipagamentosModel->getIpagamentos();
            echo view('Commons/header');
            echo view('Commons/navbartop');
            echo view('Commons/navbarleft', getBarMenu($this->usuario));
            echo view('Administrativo/Pessoas/cad_pessoas', $dados);
            echo view('Commons/footer');
        }else{
            return redirect()->to('/Acesso');
        }
    }
    public function index($id=""){
        if($this->auth->CheckAuth(11)){
            $dados['pessoa'] = $this->pessoasModel->getPessoasID(base64_decode($id));
            /*echo view('Commons/header');
            echo view('Commons/navbartop');
            echo view('Commons/navbarleft', getBarMenu($this->usuario));*/
           // echo view('Administrativo/Pessoas/cad_pessoas', $dados);
           echo view ('Administrativo/Pessoas/teste');
           // echo view('Commons/footer');
        }else{
            return redirect()->to('/Acesso');
        }
    }
    
    public function pessoasExcluir($id=""){
        if($this->auth->CheckAuth(12)){
        $this->pessoasModel->deletarPessoas(base64_decode($id));
        return redirect()->to('/Administrativo/Pessoas/pessoasConsultar?tipo_msg=sucesso&msg=Ação realizada!');
                                        }
    }
        
    public function pessoasInserir(){
        if($this->auth->CheckAuth(10)){
            $dados = array();
            $id = $this->request->getPost('id_pessoa');
            $tipo =$this->request->getPost('tipo_pessoa');
            $infos = $this->request->getPost('checkperm');
            $info_vendedor= "";
            $info_comprador= "";
            if($infos != null){
                foreach ($infos as $info){
                    if ($info=="Vendedor"){
                        $info_vendedor = "Vendedor";
                    }
                    if ($info=="Comprador"){
                        $info_comprador = "Comprador";    
                    }
                }
            }
            if($id == ""){
        
                if ($tipo=="Jurídica"){
                    $dados['NOME_PESSOA'] = $this->request->getPost('nome_empresa');
                    $dados['TIPO_PESSOA'] = $this->request->getPost('tipo_pessoa');
                    $dados['DOCUMENTO_PESSOA'] = $this->request->getPost('documento_empresa');
                    $dados['IE_PESSOA'] = $this->request->getPost('ie_empresa');
                    $dados['TELEFONE_PESSOA'] = $this->request->getPost('telefone_empresa');
                    $dados['ENDERECO_PESSOA'] = $this->request->getPost('endereco_empresa');
                    $dados['BAIRRO_PESSOA'] = $this->request->getPost('bairro_empresa');
                    $dados['CEP_PESSOA'] = $this->request->getPost('cep_empresa');
                    $dados['CIDADE_PESSOA'] = $this->request->getPost('cidade_empresa');
                    $dados['ESTADO_PESSOA'] = $this->request->getPost('estado_empresa');
                    $dados['NOME_IPAGAMENTO'] = $this->request->getPost('tipo_pagamentoe');
                    $dados['BANCO_AGENCIA'] = $this->request->getPost('banco_agenciae');
                    $dados['BANCO_CONTA'] = $this->request->getPost('banco_contae');
                    $dados['BANCO_CIDADE'] = $this->request->getPost('banco_cidadee');
                    $dados['COMPRADOR_PESSOA'] = $info_comprador;
                    $dados['VENDEDOR_PESSOA'] = $info_vendedor;
                }else{  
                    $dados['NOME_PESSOA'] = $this->request->getPost('nome_pessoa');
                    $dados['TIPO_PESSOA'] = $this->request->getPost('tipo_pessoa');
                    $dados['DOCUMENTO_PESSOA'] = $this->request->getPost('documento_pessoa');
                    $dados['IE_PESSOA'] = $this->request->getPost('ie_pessoa');
                    $dados['TELEFONE_PESSOA'] = $this->request->getPost('telefone_pessoa');
                    $dados['ENDERECO_PESSOA'] = $this->request->getPost('endereco_pessoa');
                    $dados['BAIRRO_PESSOA'] = $this->request->getPost('bairro_pessoa');
                    $dados['CEP_PESSOA'] = $this->request->getPost('cep_pessoa');
                    $dados['CIDADE_PESSOA'] = $this->request->getPost('cidade_pessoa');
                    $dados['ESTADO_PESSOA'] = $this->request->getPost('estado_pessoa');
                    $dados['NOME_IPAGAMENTO'] = $this->request->getPost('tipo_pagamentop');
                    $dados['BANCO_AGENCIA'] = $this->request->getPost('banco_agenciap');
                    $dados['BANCO_CONTA'] = $this->request->getPost('banco_contap');
                    $dados['BANCO_CIDADE'] = $this->request->getPost('banco_cidadep');
                    $dados['COMPRADOR_PESSOA'] = $info_comprador;
                    $dados['VENDEDOR_PESSOA'] = $info_vendedor;
                }
                /* $dados['USUARIO'] = $this->request->getPost('usuario_login');
                $dados['SENHA'] = sha1(preg_replace('/[^[:alnum:]_]/', '',$this->request->getPost('usuario_senha'))); 
                $dados['EMAIL'] = $this->request->getPost('usuario_email');
                $dados['TELEFONE'] = $this->request->getPost('usuario_telefone');
                $dados['ATIVO'] = $this->request->getPost('usuario_status');*/
                
                if($this->pessoasModel->setPessoas($dados)){
                    return redirect()->to('/Administrativo/Pessoas/pessoasConsultar?tipo_msg=sucesso&msg=Ação realizada!');
                }else{
                    return redirect()->to('/Administrativo/Pessoas/pessoasConsultar?tipo_msg=erro&msg=Erro ao realizar ação!');
                }
            }else{
                if ($tipo=="Jurídica"){
                    $dados['ID_PESSOA'] = $this->request->getPost('id_pessoa');
                    $dados['NOME_PESSOA'] = $this->request->getPost('nome_empresa');
                    $dados['TIPO_PESSOA'] = $this->request->getPost('tipo_pessoa');
                    $dados['DOCUMENTO_PESSOA'] = $this->request->getPost('documento_empresa');
                    $dados['IE_PESSOA'] = $this->request->getPost('ie_empresa');
                    $dados['TELEFONE_PESSOA'] = $this->request->getPost('telefone_empresa');
                    $dados['ENDERECO_PESSOA'] = $this->request->getPost('endereco_empresa');
                    $dados['BAIRRO_PESSOA'] = $this->request->getPost('bairro_empresa');
                    $dados['CEP_PESSOA'] = $this->request->getPost('cep_empresa');
                    $dados['CIDADE_PESSOA'] = $this->request->getPost('cidade_empresa');
                    $dados['ESTADO_PESSOA'] = $this->request->getPost('estado_empresa');
                    $dados['NOME_IPAGAMENTO'] = $this->request->getPost('tipo_pagamentoe');
                    $dados['BANCO_AGENCIA'] = $this->request->getPost('banco_agenciae');
                    $dados['BANCO_CONTA'] = $this->request->getPost('banco_contae');
                    $dados['BANCO_CIDADE'] = $this->request->getPost('banco_cidadee');
                    $dados['COMPRADOR_PESSOA'] = $info_comprador;
                    $dados['VENDEDOR_PESSOA'] = $info_vendedor;
                }else{
                    $dados['ID_PESSOA'] = $this->request->getPost('id_pessoa');
                    $dados['NOME_PESSOA'] = $this->request->getPost('nome_pessoa');
                    $dados['TIPO_PESSOA'] = $this->request->getPost('tipo_pessoa');
                    $dados['DOCUMENTO_PESSOA'] = $this->request->getPost('documento_pessoa');
                    $dados['TELEFONE_PESSOA'] = $this->request->getPost('telefone_pessoa');
                    $dados['ENDERECO_PESSOA'] = $this->request->getPost('endereco_pessoa');
                    $dados['BAIRRO_PESSOA'] = $this->request->getPost('bairro_pessoa');
                    $dados['CEP_PESSOA'] = $this->request->getPost('cep_pessoa');
                    $dados['CIDADE_PESSOA'] = $this->request->getPost('cidade_pessoa');
                    $dados['ESTADO_PESSOA'] = $this->request->getPost('estado_pessoa');
                    $dados['NOME_IPAGAMENTO'] = $this->request->getPost('tipo_pagamentop');
                    $dados['BANCO_AGENCIA'] = $this->request->getPost('banco_agenciap');
                    $dados['BANCO_CONTA'] = $this->request->getPost('banco_contap');
                    $dados['BANCO_CIDADE'] = $this->request->getPost('banco_cidadep');
                    $dados['COMPRADOR_PESSOA'] = $info_comprador;
                    $dados['VENDEDOR_PESSOA'] = $info_vendedor;
                    /* $dados['NOME'] = $this->request->getPost('usuario_nome');
                    $dados['USUARIO'] = $this->request->getPost('usuario_login');
                    $dados['EMAIL'] = $this->request->getPost('usuario_email');
                    $dados['TELEFONE'] = $this->request->getPost('usuario_telefone');
                    $dados['ATIVO'] = $this->request->getPost('usuario_status');*/
                }
                
                if($this->pessoasModel->updatePessoas($dados)){
                    
                    return redirect()->to('/Administrativo/Pessoas/pessoasConsultar?tipo_msg=sucesso&msg=Ação realizada!');
                }else{
                    return redirect()->to('/Administrativo/Pessoas/pessoasConsultar?tipo_msg=erro&msg=Erro ao realizar ação!');
                }
            }
        }else{
            return redirect()->to('/Acesso');
        }
    }

    public function pessoasVerificar(){
        $documento = $this->request->getPost('documento');
        $resultado = $this->pessoasModel->pessoasVerificar($documento);
        echo json_encode($this->pessoasModel->pessoasVerificar($documento));
        //echo ($documento);
        //echo json_encode($this->pessoasModel->pessoasVerificar($this->request->getPost('documento')));
    }

    public function pessoasVendedor(){
        $documento = $this->request->getPost('id_vendedor');
        $resultado = $this->pessoasModel->pessoasVendedor($documento);
        echo json_encode($this->pessoasModel->pessoasVendedor($documento));
        //echo ($resultado);
        //echo json_encode($this->pessoasModel->pessoasVerificar($this->request->getPost('documento')));
    }
        
}
