<?php namespace App\Models\Configuracoes;

use CodeIgniter\Model;

class EmpresaModel extends Model{

    public function __construct(){
        $this->db      = \Config\Database::connect();
        $this->builder = $this->db->table('CON_EMPRESA');
        $this->session = \Config\Services::session();
        $this->usuario = $this->session->get('dadoslogin');
    }

    function getEmpresa(){
        return $this->builder->get();
    }

    function getEmpresaID($id){
        $this->builder->where('ID_EMPRESA', $id);
        //return $builder->get()->getRow();
        return $this->builder->get()->getRow();
    }

    function salvarEmpresa($dados){
        $builder = $this->db->table('CON_EMPRESA');
        $builder->insert($dados);
        $id = $this->db->insertID();
        sys_log($this->usuario['ID_USUARIO'], "Inserção de dados ID: ".$id."", "CON_EMPRESA");
        return $id;
    }

    function updateEmpresa($dados){
        $builder = $this->db->table('CON_EMPRESA');
        $builder->where('ID_EMPRESA', $dados['ID_EMPRESA']);
        $builder->update($dados);
        sys_log($this->usuario['ID_USUARIO'], "Atualização de dados ID: ".$dados['ID_EMPRESA']."", "CON_EMPRESA");
        return $this->db->affectedRows();
    }

    function empresaDeletar($idempresa){   
        $this->builder->where('ID_EMPRESA', $idempresa);
        $resultado = $this->builder->get()->getRow();
        $caminho = $resultado->CAMINHO_IMAGEM;
        $path_to_file = '.'.$caminho;
        if ($caminho != ""){
                if(unlink($path_to_file)) {
                    echo 'deleted successfully';
                                          } 
                            }   
                                        
                                        }

    
}
?>