﻿// (c) ammap.com | SVG (in JSON format) map of India - Low
// areas: {id:"IN-AN"},{id:"IN-AP"},{id:"IN-AR"},{id:"IN-AS"},{id:"IN-BR"},{id:"IN-CH"},{id:"IN-CT"},{id:"IN-DD"},{id:"IN-DL"},{id:"IN-DN"},{id:"IN-GA"},{id:"IN-GJ"},{id:"IN-HP"},{id:"IN-HR"},{id:"IN-JH"},{id:"IN-JK"},{id:"IN-KA"},{id:"IN-KL"},{id:"IN-LD"},{id:"IN-MH"},{id:"IN-ML"},{id:"IN-MN"},{id:"IN-MP"},{id:"IN-MZ"},{id:"IN-NL"},{id:"IN-OR"},{id:"IN-PY"},{id:"IN-PB"},{id:"IN-RJ"},{id:"IN-SK"},{id:"IN-TN"},{id:"IN-TR"},{id:"IN-UP"},{id:"IN-UT"},{id:"IN-WB"}
AmCharts.maps.indiaLow={
	"svg": {
		"defs": {
			"amcharts:ammap": {
				"projection":"mercator",
				"leftLongitude":"68.140539",
				"topLatitude":"35.503357",
				"rightLongitude":"97.383868",
				"bottomLatitude":"6.749824"
			}
		},
		"g":{
			"path":[
				{
					"id":"IN-AN",
					"title":"Andaman and Nicobar Islands",
					"d":"M511.39,665.49l-0.6,3.97l-1.1,0.49l-0.43,-1.15l-0.62,0.33l-0.91,3.46l-1.48,0.01l0.56,-8.99l2.12,-4.52l1.28,-0.59l1.08,0.53L511.39,665.49zM508.6,672.37l1.31,4.19l-0.13,4.23l-1.07,1.89l-0.69,-0.68l-1.06,0.42l0.93,2.22l-2.78,0.35l-0.92,-1.1l0.46,-9.45l1.58,-1.78L508.6,672.37zM506.56,684.73l1.49,1.08l-0.83,2.16l-2.19,1.9l0.74,-2.73l-0.72,-1.62L506.56,684.73zM504.26,687.54l1.01,0.08l-0.33,2.18l0.94,3.6l-1.63,8.54l-2.01,-2.33l-1.91,-5.24l0.53,-1.33l1,0.54l0.51,-1.04l0.38,-4.37l1.37,-1.7L504.26,687.54zM502.54,704.79l-0.75,-0.41l0.9,-2.88l1.28,2.68L502.54,704.79zM499.71,722.13l-2.79,-0.48l-0.26,-3.14l0.21,-1.99l2.9,-2.3l1.62,4.15L499.71,722.13zM505.7,750.95l-1.6,-0.77l1.03,-2.04l0.96,1.08L505.7,750.95zM521.04,773.39l-1.06,0.97l-0.75,-2.99l1.43,-1.85L521.04,773.39zM519.51,776.48l-2.34,0.08l-0.62,-2.3l1.42,-0.44L519.51,776.48zM524.99,788.07l-1.86,1.59l-0.83,-1.23l2,-2.67L524.99,788.07zM528.52,798.68l-1.82,1.11l-0.94,-3.44l-2.4,-2.3l0.51,-3.11l2.8,-1.08l1.09,0.76l1.38,5.14L528.52,798.68z"
				},
				{
					"id":"IN-AP",
					"title":"Andhra Pradesh",
					"d":"M248.82,549.29l0.39,0.02l0,0l1.34,2.61l0,0l3.06,-0.5l1.56,0.69l0,0l3.72,4.16l-0.19,4.17l4.21,2.86l0,0l1.09,5.75l0.88,0.69l0,0l0.68,-0.4l0,0l1.66,-1.3l7.43,0.96l0,0l4,-1.01l0.97,-1.69l6.83,-3.4l2.93,1.77l1.75,-1.99l-0.79,-2.58l1.36,-5.17l1.36,-1.75l1.81,0.54l2.11,5.46l4.58,-4.2l2.15,1.38l2.39,-0.76l0.33,-2.84L305.2,550l2.04,-2.6l2.64,0.19l2.34,-1.31l0.78,-1l-2.06,-2.29l0.83,-0.8l1.81,0.89l1.56,-0.91l1.22,-2.5l1.12,-0.55l2.45,4.03l0.29,-1l0.98,0.89l-0.09,3.69l2.15,0.59l1.85,-0.61l1.76,0.89l4.35,-0.77l5.8,-7.36l3.29,0.96l0,0l0.68,1.35l-1.71,2.58l-12.3,14.53l-10.17,5.39l-7.12,9.06l-12.7,6.44l-5.19,4.12l-2.33,3.97l0.53,1.09l1.88,0.64l0.08,-0.82l-1.39,6.09l-6.42,3.78l-5.37,2.01l-6.46,-1.58l-1.87,0.39l-1.5,1.12l-2,7.31l-3.08,2.76l0.27,1.2l-2.29,-1.69l-0.39,-3.15l0.11,2.84l-1.29,2.67l-0.99,-2.67l-1.9,-0.47l-2.62,0.47l-5.7,3.79l-3.81,8.12l-0.92,5.5l2.99,10.54l-1.41,7.48l3.76,16l-3.21,-5.87l-2.11,2.04l1.42,2.54l0,0l-1.51,-0.2l-6.02,6.62l-5.58,-2.93l-1.8,0.63l1.19,0.36l0.11,1.92l-7.21,3.45l-4.26,-1.38l-3.27,0.43l-2.39,1.59l-0.01,3.79l-3.22,4l-3.76,-1.38l-0.55,-1.65l0,0l2.45,-3.49l2.37,1.56l-0.37,-3.46l2.13,-3.25l-0.01,-2.56l-0.72,0.83l-3.24,-1.42l0.45,-5.4l-3.41,0.22l-2.78,-1.42l0.53,-4.48l-3.53,-0.52l-0.05,-1.36l-2.82,0.32l-0.42,2.75l-2.76,0.44l-0.41,0.99l-3.66,0.43l-0.57,-2.57l-4.92,-0.44l-0.33,2.1l-3.5,0.51l-0.45,-1.91l1.41,-2.03l-2.9,-4.76l2.23,-0.54l0.44,2.6l2.25,1.1l3.28,-0.51l1,2.54l0.99,0.41l0.71,-0.4l-1.89,-4.47l1.55,-0.98l1.61,0.32l-0.17,-2.48l-1.82,-1.47l-0.41,1.21l-4.26,-0.95l-1.69,2.53l-3.09,-0.64l-1.47,-2.74l2,-2.16l-2.23,-0.32l-2.08,-2.8l0.46,-3.16l1.18,-0.55l0.38,-1.43l-0.02,-1.77l-2.38,-0.6l0.7,-2.17l5.81,1.28l1.3,-0.61l0.98,-2.26l-0.32,-2.21l-3.55,-5.38l1.26,-2.8l1.36,0.07l-1.89,-4.46l2.73,-2.42l7.26,0.5l-0.45,-6.62l2.05,-1.02l-1.62,-1.5l-3.21,-0.28l-2.1,-1.47l2.53,-0.53l2.04,-2.34l-0.3,-7.9l-1.36,-5.38l3.32,-4.64l2.32,-0.96l-4.09,-2.84l0.78,-4.39l3.23,-2.87l-1.83,-4.83l0.31,-2.23l0,0l-0.28,-3.44l1.36,-2.2l2.29,0.18l-0.31,-3.65l1.73,-2.22l2.4,-0.62l0.67,-1.01l-2.11,-2.27l-0.49,-1.89l1.94,-4.2l-0.39,-1.3l1.66,-0.71l2.25,2.19l2.25,-0.46l-0.15,-3.4l2.73,-1.01l-0.35,-4.66l1.46,-1.31l0.08,-1.46l9.33,1.13l1.01,0.55l-0.64,1.05l2.45,1.49l4.59,-0.92l7.08,3.38l3.33,-2.02l1.45,0.28l3.53,3.93l-0.56,5.25l-1.61,1.39v1.47l1.33,-0.31l1.39,5.68l1.94,1.96L248.82,549.29zM289.27,591.97L289.27,591.97l-0.4,-1.24l1.83,1.17L289.27,591.97z"
				},
				{
					"id":"IN-AR",
					"title":"Arunachal Pradesh",
					"d":"M589.81,351.84L590.16,355.12L595.4,362.68L594.92,363.62L589.72,361.43L588.48,358.24L586.52,357.23L575.54,359.43L572.23,361.32L569.82,364.91L567.64,365.56L563.54,369.66L561.52,369.9L560.24,372.2L556.47,373.62L555.99,373.02L554.08,374.39L552.46,377.6L552.46,379.54L552.46,379.54L545.67,375.79L539.21,375.23L539.21,375.23L539.22,374.89L539.22,374.89L541.36,373.04L545.78,371.43L549.44,367.24L551.87,367.65L559.78,363.18L562.05,359.95L565.07,360.48L570.98,359.58L572.73,356.77L571.49,355.59L570.07,356.44L569.87,352.91L567.99,351.63L567.46,349.35L571.54,343.08L565.56,343.35L562.87,345.14L560.27,345.99L557.6,345.49L542.36,351.75L536.38,352.26L536.05,353.83L527.32,361.6L526.83,364.1L523.74,366.27L519.72,367.1L516.9,366.29L516.22,367.38L513.29,368.05L506.18,367.89L502.77,365.95L498.76,367.65L491.22,368.61L491.22,368.61L491.62,366.09L489.75,363.29L489.86,361.76L491.89,358.89L491.38,357.6L489.42,354.7L484.85,355.71L482.9,354.43L481.35,351.48L482.53,348.04L485.95,348L487.88,349.18L492.1,346.91L494.83,346.77L494.96,345.88L495.86,347.7L499.84,346.27L501.05,346.74L504.72,342.85L503.4,340.74L504.05,339.42L509.48,336.58L510.07,337.26L510.8,335.58L514.62,335.21L514.49,332.92L517.29,328.26L520.37,326.85L523.35,327.59L527.68,326.59L529.8,327.09L531.02,323.2L533.71,321L535.4,317.66L539.36,314.34L542.51,313.97L543.87,311.58L546.81,314.09L546.96,315.53L548.16,315.08L559.52,318.58L562.32,316.37L562.24,314.89L563.88,313.45L570.74,310.43L573.05,308.56L576.62,313.88L579.03,312.74L579.66,313.36L578.78,315.14L573.97,317.57L574.68,318.11L574.6,320.84L575.22,321.68L578.74,318.63L581.28,318.06L581.56,320.12L584.25,324.88L581.32,326.64L581.73,327.58L578.3,330.23L578.78,331.65L577.03,333.03L579.04,333.49L579.82,334.63L581,332.92L585.11,331.81L587.68,334.03L592.07,335.28L594.04,334.04L599.3,337.45L598.64,340.58L599.95,342.8L599.55,343.97L593.1,348.38z"
				},
				{
					"id":"IN-AS",
					"title":"Assam",
					"d":"M491.22,368.61L498.76,367.65L502.77,365.95L506.18,367.89L513.29,368.05L516.22,367.38L516.9,366.29L519.72,367.1L523.74,366.27L526.83,364.1L527.32,361.6L536.05,353.83L536.38,352.26L542.36,351.75L557.6,345.49L560.27,345.99L562.87,345.14L565.56,343.35L571.54,343.08L567.46,349.35L567.99,351.63L569.87,352.91L570.07,356.44L571.49,355.59L572.73,356.77L570.98,359.58L565.07,360.48L562.05,359.95L559.78,363.18L551.87,367.65L549.44,367.24L545.78,371.43L541.36,373.04L539.22,374.89L539.22,374.89L539.21,375.51L539.21,375.51L537.29,378.3L536.14,375.88L534.21,379.83L534.21,379.83L530.62,385.01L530.62,385.01L529.85,391.44L526.14,392.88L526.01,390.01L524.2,390.23L520.05,396.31L516.48,398.99L519.04,402.01L518.62,405.09L519.4,405.56L519.4,405.56L517.75,407.19L515.61,413.3L511.75,417.58L510.62,424.73L510.62,424.73L507.06,425.28L505.18,422.18L502.57,428.07L499.64,430.47L498.55,430.25L498.42,428.39L495.83,428.37L495.83,428.37L493.96,428.45L494.96,425.65L494.64,423.45L492.44,421.67L492.44,421.67L493.41,420.86L494.65,416.82L494.65,413.4L497.55,414.43L499.64,413.79L498.01,410.72L498.01,410.72L500.91,408.32L506.02,406.22L505.71,403.71L504.24,401.98L502.71,401.77L501.28,399.88L502.13,398.35L498.11,394.13L492.96,395.94L493.12,389.41L494.84,387.21L492.9,386.93L488.65,388.2L485.96,386.7L483.76,387.18L480.81,388.36L479.18,391.52L476.15,392.31L473.52,394.71L472.96,392.65L469.49,392.2L469.58,390.78L464.08,389.62L460.81,389.89L459.12,388.53L456.67,388.18L451.52,389.46L449.41,391.01L447.4,394.39L448.67,397.58L445.46,399.4L445.46,399.4L445.7,396.42L444.57,392.45L445.42,390.55L445.03,388.44L443.05,384.87L441.32,384.11L441.32,384.11L444.38,380.88L444.27,372.32L444.27,372.32L451.57,371.21L452.96,369.03L456.49,367.83L463.05,370.82L471.49,369.98L475.34,370.69L477.59,368.56L479.32,368.65L480.17,370.07L483.71,370.17L486.23,368.75z"
				},
				{
					"id":"IN-BR",
					"title":"Bihar",
					"d":"M403.15,407.84L396.54,404.85L396.69,406.47L395.8,406.47L395.65,407.95L392.55,407.8L390.77,411.21L389.15,411.65L386.49,421.41L385.16,421.41L384.27,423.63L382.05,421.85L379.54,423.63L378.95,422L377.91,422L376.58,423.48L375.69,426.58L374.51,427.17L372.59,426.29L372.29,422.74L369.04,423.18L369.04,419.93L367.41,417.86L363.72,418.6L362.68,417.56L361.05,417.56L359.13,422.15L357.36,422.44L356.77,424.22L352.63,424.22L351.15,426.14L348.63,425.84L347.75,427.47L344.79,426.29L344.05,424.51L342.13,424.22L340.8,426.58L338.87,426.58L338.73,428.51L334.88,427.47L334.14,424.81L332.66,423.33L330.59,424.66L326.45,421.7L325.42,423.63L317.43,423.33L315.08,421.9L315.08,421.9L315.82,421.48L315.82,421.48L316.37,419.74L316.37,419.74L314.98,416.74L314.98,416.74L311.3,409.97L311.3,409.97L312.26,406.08L313.57,404.54L313.57,404.54L314.49,404.02L314.49,404.02L320.43,401.77L321.61,400.43L321.61,400.43L325.46,397.28L325.46,397.28L327.44,394.88L327.44,394.88L333.66,395.2L333.66,395.2L335.35,395.79L337.49,394.84L337.49,394.84L337.71,393.89L337.71,393.89L335.26,391.48L329.06,388.6L326.69,385.43L326.27,383.71L329.35,382.53L329.35,382.53L329.34,380.22L323.93,377.49L323.93,377.49L324,376.36L325.35,376.09L325.35,376.09L325.75,376.28L325.75,376.28L326.88,376.31L327.3,375.21L327.3,375.21L327.6,374.27L328.76,374.14L333.89,374.51L333.84,373.13L333.84,373.13L330.77,370.26L330.77,370.26L330.32,368.33L328.49,369.29L328.49,369.29L326.76,367.56L326.76,367.56L325.01,360.72L322.23,358.13L322.23,358.13L322.77,355.51L325.8,355.45L328.42,353.88L331.51,356.71L338.5,358.48L339.46,360.89L338.85,364.69L342.95,365.72L350.48,371.04L352.65,371.65L358.86,368.68L360.91,370.49L360.88,373.08L363.58,375.38L367.12,373.32L370.64,375.04L373.3,374.58L381.49,378.86L387.05,376.26L390.45,379.32L392.49,379.89L396.3,378.56L400.15,379.49L405.31,377.74L407.89,380.04L409.34,378.57L409.57,376.35L411.47,376.29L413.18,380.24L403.98,387.78L403.98,390.88L408.83,395.53L408.48,398.5L408.48,398.5L408.13,399.3L406.22,398.71L406.22,398.71L403.17,401.58z"
				},
				{
					"id":"IN-CH",
					"title":"Chandigarh",
					"d":"M178.54,277.52L178.21,279.82L178.21,279.82L177.43,280.31L175.43,278.54L176.79,277.33z"
				},
				{
					"id":"IN-CT",
					"title":"Chhattisgarh",
					"d":"M258.25,491.73L260.06,488.32L259.17,483.88L261.84,483.14L261.25,478.11L262.87,477.67L263.02,475.01L265.39,475.6L265.68,473.68L264.94,473.09L265.83,471.31L267.46,471.17L267.31,466.88L268.93,467.17L272.19,465.99L274.11,466.73L275,465.55L277.51,464.96L277.66,463.62L280.62,462.29L280.47,460.37L282.39,458.15L282.83,455.49L284.02,454.16L287.86,453.27L288.16,449.28L285.35,445.88L284.31,446.03L282.98,443.96L282.24,444.7L281.21,443.51L278.1,444.25L277.07,443.22L276.62,442.04L278.99,438.63L277.21,436.27L278.25,435.23L281.5,437.16L287.12,436.71L289.49,438.04L294.66,438.19L295.7,439.52L296.58,437.45L298.06,437.6L298.8,435.09L300.76,434.38L300.76,434.38L301.24,434.74L301.24,434.74L304.14,436L304.14,436L308.29,435.09L308.29,435.09L308.67,434.2L308.67,434.2L308.91,432.54L312.05,431.13L312.05,431.13L315.47,435.69L317.99,436.82L319.39,441.63L322.66,442.25L323.79,440.47L324.92,440.72L325.3,442.62L324.3,444.14L324.37,446.49L325.5,446.04L329.37,452.88L334.46,454.34L334.69,455.91L332.48,457.87L331.92,459.55L326.92,463.54L327.39,466.31L327.39,466.31L327.39,466.31L327.39,466.31L326.05,468.18L326.05,468.18L324.3,468.26L321.5,470.87L321.5,470.87L319.88,471.05L318.63,473.02L317.82,475.63L318.35,477.03L318.35,477.03L318.86,479.22L317.85,480.43L317.85,480.43L316.77,480.68L316.77,480.68L316.66,483.79L316.66,483.79L313.92,486.79L315.11,488.52L315.11,488.52L314.88,490.87L312.59,490.46L311.04,494.54L311.04,494.54L309.67,495.77L299.83,495.32L299.83,495.32L297.31,499.54L296.75,502.32L295.25,502.29L295.25,502.29L293.49,501.38L293.49,501.38L293.45,502.3L293.45,502.3L295.13,511.71L295.13,511.71L295.59,513.61L295.59,513.61L295.33,515.66L295.33,515.66L295.22,519.28L295.22,519.28L299.33,521.22L301.01,520.5L301.96,523.99L301.96,523.99L299.69,525.7L299.69,525.7L299.12,524.32L299.12,524.32L294.87,524.71L294.87,524.71L291.8,520.93L291.8,520.93L291.14,521L291.14,521L287.33,520.63L287.33,520.63L286.14,519.43L286.14,519.43L285.53,518.81L283.76,520.08L283.85,522.97L283.85,522.97L285.65,524.04L285.65,524.04L287.65,525.69L287.75,527.45L287.75,527.45L287.75,531.86L290.84,533.87L290.53,537.47L291.36,540.81L291.36,540.81L292.07,544.88L290.64,547.38L285.41,550.77L285.41,550.77L285.69,552.4L282.08,556.89L282.08,556.89L277.76,560.03L276.81,565.52L276.81,565.52L276.15,567.05L276.15,567.05L274.66,569.01L267.23,568.05L265.57,569.34L265.57,569.34L264.89,569.74L264.89,569.74L264.01,569.05L262.92,563.3L262.92,563.3L258.71,560.44L258.9,556.27L255.18,552.1L255.18,552.1L253.61,551.41L250.55,551.91L250.55,551.91L249.21,549.31L249.21,549.31L248.43,548.32L248.43,548.32L250.65,546.88L249.13,544.88L249.13,544.88L249.59,542.41L249.59,542.41L250.13,541.41L250.13,541.41L251.54,537.77L251.54,537.77L253.26,535.93L253.26,535.93L255.22,534.62L255.22,534.62L255.79,536.24L258.7,538.36L262.07,535.74L263.29,532.31L258.19,529.93L258.19,529.93L258.63,528.08L258.63,528.08L255.21,525.25L255.21,525.25L254.74,526.44L253.71,526.62L253.71,526.62L252.62,526.1L254.46,522.91L254.46,522.91L255.82,521.74L255.82,521.74L256.13,518.14L252.88,518.32L252.88,518.32L252.83,516.25L257.25,513.63L257.25,513.63L256.93,508.35L256.93,508.35L255.56,508.65L254.67,507.8L254.67,507.8L255.18,507.07L255.18,507.07L256.32,506.47L255.27,500.56L255.27,500.56L254.3,500.81L254.3,500.81L253.65,496.29L255.99,494.13L255.99,494.13L258.45,491.79L258.45,491.79z"
				},
				{
					"id":"IN-DD",
					"title":"Daman and Diu",
					"d":"M96.69,511.41L98.07,512.04L98.07,512.04L98.46,513.96L95.29,513.87z"
				},
				{
					"id":"IN-DL",
					"title":"Delhi",
					"d":"M185.56,323.01L186.86,328.19L189.09,330.92L189.09,330.92L185.72,332.96L182.42,330.11L179.46,330.97L178.56,329.46L180.88,326.95L180.9,323.86L183.55,322.48z"
				},
				{
					"id":"IN-DN",
					"title":"Dadra and Nagar Haveli",
					"d":"M103.07,517.02l1.75,1.25l0,0l-0.11,0.72l0,0l-1.04,1.5l-2.7,-0.24l-1.57,-1.31l-0.09,-1.23l0,0l1.43,-2.05l2.03,-1.02l0,0l0,0l0,0L103.07,517.02z"
				},
				{
					"id":"IN-GA",
					"title":"Goa",
					"d":"M124.76,613.17L123.7,614.29L124.07,614.86L125.03,614.25L126.79,614.81L126.7,618.55L127.91,622.42L126.7,622.85L126.81,629.13L122.3,631.24L122.3,631.24L119.37,627.05L118.29,622.07L115.89,620.01L119.4,620.72L119.19,620.02L115.99,618.93L114.01,613.17L114.01,613.17L115.41,613.1L117.24,611.58L121,616.14L122.48,615.35L122.3,614.32L123.51,612.84z"
				},
				{
					"id":"IN-GJ",
					"title":"Gujarat",
					"d":"M81.29,418.58l0.61,1.19l2.42,-0.13l0,0l0.01,1.5l0,0l0,0l0,0l8.46,2.31l0,0l0.61,1.29l0,0l1.21,0.79l3.52,-0.24l1.3,-2.52l2.41,-0.33l0,0l0,0l0,0l0.82,3.79l-1.4,2.62l0.31,1.3l0,0l0,0l0,0l3.03,3.06l2.41,-1.93l0.91,0.99l0,0l0,0l0,0l0.52,3.09l-1.5,1.62l0.61,1.59l0,0l0,0l0,0l0,0l0,0l2.62,1.37l1.02,1.98l1.31,0.09l0,0l0.81,1.18l-0.49,2.4l0,0l0,0l0,0l3.92,0.65l0,0l1.31,1.57l0,0l1.11,0.69l0.8,-0.61l3.12,2.24l0,0l0.21,1.69l2.21,-0.22l1.12,1.97l0,0l1.35,1.93l0,0l0,0l0,0l0,0l0,0l1.89,-0.5l0.15,0.89l-2.51,4.96l-6.92,2.4l0,0l-0.25,1.23l1.68,1.61l1.94,-0.52l1,1.17l0,0l-2.99,0.88l0,0l-0.99,-0.88l0,0l-0.18,2.18l0,0l1.74,4.68l0,0l-0.99,1.82l1.1,3.48l0,0l-5.07,2.31l0.86,4.3l-2.18,0.73l1.23,2.84l0,0l0,0l0,0l3.74,-1.35l5.57,0.05l0,0l0,0l0,0l-0.86,1.78l-3.92,0.2l-2,1.35l-0.73,2.54l-3.17,2.37l-1.83,0.81l-2.05,-0.79l1.36,2.21l0,0l0,0l0,0l2.97,0.69l0,0l0,0l0,0l2.54,5.07l-0.13,1.64l-2.34,3.11l-2.91,0.91l-3.75,-2.71l0,0l-0.3,-0.35l0,0l-1,1.42l1.22,1.85l-1.76,7.77l-2.74,1.78l-0.69,-0.43l0,0l0,0l0,0l0.11,-0.72l0,0l-1.75,-1.25l0,0l-0.3,-2.38l0,0l0,0l0,0l-2.03,1.01l-1.43,2.05l-1.7,-0.78l-1.34,2.04l-2.14,-0.34l0,0l0,0l0,0l1.11,-4.65l3.23,0.01l-0.39,-1.93l0,0l-1.38,-0.63l0,0l1.67,-6.78l-1.78,-1.49l0.11,-4.85l-0.95,-1.32l-3.69,0.88l1.8,-2.54l-2.03,-1.11l-1.04,-2.69l3.79,-1.95l-3.24,1.01l0.81,-1.67l3.82,-3.06l6.35,-2.72l-3.91,1.67l-8.01,0.39l0.42,-4l3.21,-3.17l-3.77,1.75l-0.76,-1.41l1.62,-4.92l3.5,0.69l1.27,-1.53l2.12,0.37l-0.04,-1.14l-6.79,-0.32l-2.37,1.27l-1.62,-0.53l-0.28,-1.04l-4.53,0.39l2.97,1.19l0.52,1.67l-1.23,2.98l-4.64,1.7l2.22,0.26l0.33,1.97L79.16,481l0.5,1.77l2.96,-0.33l2.52,3.9l-1.05,3.32l-2.76,3.33l0.09,2.25l-11.08,5.01l-2.59,2.2l-9.81,3.75l-2.84,0.14l-6.2,-2.57l-9.48,-7.22l-5.58,-7.05l-13.81,-13.09l-3.48,-5l0.83,-2.85l1.74,-1.38l3.06,4.56l9.85,-2.9l6.93,-3.33l2.7,0.13l4.05,-7.47l2.78,-1.91l0.14,-2.74l-0.57,-0.62l-1.38,0.82l-0.42,3.3l-3.42,-0.39l-7.91,2.24l-2.7,2.51l-10.15,-2.16l-11.42,-6.83l-4.64,-6.26l-0.5,-3.96l6.83,-5.26l-5.98,2.59l-2.47,3.19l-3.8,-0.54l1.12,-1.2l0.2,-4.19l1.66,-2.4l0.8,0.63l0.72,-1.41l0.59,0.56l2.13,-0.97l0.37,1.4l0.7,-0.85l4.13,0.57l0.88,-7.56l0.7,-0.19l0.44,2.24l0.82,0.28l1.23,-1.81l1.09,1.14l1.9,-0.97l2.19,0.76l2.27,-0.93l5.96,-0.03l2.52,2.39l5.68,0.11l1.3,-0.61l1.13,-2.17l9.35,-2.9l0.76,0.44l-0.77,3.32l4.75,0.66l1.81,-0.77l-0.18,-0.75l1.53,-1.24l1.79,-0.02l1.74,-1.22l-2.55,-0.91l-0.14,-3.52l1.95,-1.6l3.36,1.25l4.92,-1.47l3.52,1.06l6.93,-1.29L81.29,418.58z"
				},
				{
					"id":"IN-HP",
					"title":"Himachal Pradesh",
					"d":"M210.73,235.72L211.29,237.26L212.94,238.18L211.31,242.34L214.46,243.01L214.55,245.34L218.12,248.29L216.48,253.25L217.37,255.69L218.29,255.74L219.35,257.53L216.8,259.85L218.62,261.42L218.23,262.65L221.06,266.01L221.06,266.01L222.66,269.79L219.85,269.89L218.82,267.65L212.26,267.31L208.76,265.98L203.37,268.77L200.76,269.07L197.58,273.61L196.92,278.51L198.64,283.92L193.42,286.06L193.76,286.9L193.76,286.9L193.76,286.9L193.76,286.9L187.61,285.49L184.61,283.49L185.19,280.22L181.74,278.16L179.65,275.09L177.52,274.51L177.52,274.51L174.22,272.12L174.45,267.8L170.76,264.88L170.04,263.37L168.4,263.42L167.53,264.86L165.32,264.92L164.81,261.98L160.39,253.1L161.25,252.44L160.48,250.83L155.01,246.59L154.1,243.32L154.63,242.22L158.92,240.59L160.57,238.5L158.23,235.59L158.23,235.59L159.8,233.57L159.62,230.59L157.06,226.35L158.79,225.81L160.53,226.9L169.94,219.79L176.32,220.05L178.62,221.1L184.54,226.44L189.55,228.17L196.68,224.23L200.75,229.76L202.3,233.99L203.32,234.27L204.79,232.72L206.96,232.48L210.04,230.26L210.23,232.72L208.23,237.04L208.78,237.54z"
				},
				{
					"id":"IN-HR",
					"title":"Haryana",
					"d":"M193.76,286.9L193.77,287.99L193.77,287.99L192.57,291.47L189.31,293.73L189.31,293.73L185.88,297.24L185.88,297.24L185.28,300.53L184.38,300.67L184.38,300.67L184.47,316.8L185.77,319.77L185.56,323.01L185.56,323.01L185.56,323.01L185.56,323.01L183.55,322.48L180.9,323.86L180.88,326.95L178.56,329.46L179.46,330.97L182.42,330.11L185.72,332.96L189.09,330.92L189.09,330.92L191.91,333.62L192.54,336.72L191.33,340.22L192.34,342.92L188.5,346.28L188.5,346.28L186.82,347.21L185.39,346.65L181.78,348.95L181.56,349.94L179.93,350.11L181.07,339.24L178.95,337.34L174.74,340.42L172.81,343.54L170.7,341.58L170.34,340.02L171.14,339.55L168.42,338.77L167.92,342.02L166.53,341.08L165.03,341.25L164.56,342.23L165.45,345.6L164.46,346.57L160.92,346.26L159.86,340.36L161.79,338.79L163.18,339.1L159.64,334.26L155.22,331.29L152.04,327.49L150.45,321.21L151.41,319.8L148.66,317.81L148.87,313.43L141.99,313.6L139.32,312.43L138.58,310.31L137.27,309.82L132.13,311.16L130.94,308.49L132.63,306.84L131.75,306.16L132.35,301.27L130.62,301.87L129.35,301.18L130.5,299.54L130.71,296.93L130.71,296.93L133.38,297.73L136.99,296L140.73,298.87L144.75,299.69L145.47,301.72L144.14,303.65L145.57,306.42L147.03,305.95L147.42,303.59L150.13,300.46L152.76,301.85L157.08,300.07L158.92,301.76L162.42,301.94L166.34,299.13L165.83,296.06L166.78,292.92L172.32,294.12L174.21,292.6L174.71,291.35L173.85,290.22L176.07,287.65L176.23,286.24L178.65,286.05L179.06,287.63L179.84,287.63L180.18,282.22L178.21,279.82L178.21,279.82L178.54,277.52L178.54,277.52L177.52,274.51L177.52,274.51L179.65,275.09L181.74,278.16L185.19,280.22L184.61,283.49L187.61,285.49z"
				},
				{
					"id":"IN-JH",
					"title":"Jharkhand",
					"d":"M403.15,407.84L404.55,409.77L404.55,409.77L404.93,410.36L404.93,410.36L405.97,418.61L405.17,420.16L405.17,420.16L402.08,426.51L400.45,427.94L401.18,429.19L401.18,429.19L397.08,430.93L397.08,430.93L396.65,433.42L396.65,433.42L393.41,432.46L393.41,432.46L392.01,432.44L392.01,432.44L392.45,433.37L392.45,433.37L393.1,435.39L393.1,435.39L392.16,437.13L389.65,437.97L387.18,436.77L387.18,436.77L386.79,436.6L386.79,436.6L385.29,436.03L383.41,437.59L383.41,437.59L383.51,438.39L383.51,438.39L383.68,440.43L382.09,440.79L381.25,439.94L381.25,439.94L378.39,440.54L378.39,440.54L374.51,443.2L374.51,443.2L374.04,445.31L374.04,445.31L372.67,446.68L369.62,445.08L369.32,442.82L367.43,442.87L365.28,445.25L363.02,450.07L363.02,450.07L363.94,451.94L365.43,452.12L365.43,452.12L366.98,452.17L370.24,455.25L370.24,455.25L372.95,455.7L372.95,455.7L377.98,456.03L376.17,457.48L375.5,460.27L375.5,460.27L377.18,461.76L377.18,461.76L379.46,462.48L379.46,462.48L382.65,465.03L385.22,470.86L384.89,471.68L383.66,471.5L380.69,473.16L380.69,473.16L378.13,470.64L378.13,470.64L375.7,470.25L375.7,470.25L374.45,470.19L374.45,470.19L373.86,469.79L373.86,469.79L372.21,467.53L370.7,466.94L370.7,466.94L368.47,466.02L368.47,466.02L367.35,465.16L367.35,465.16L365.58,466.1L365.58,466.1L366.04,467.1L366.04,467.1L366.83,468.49L366.89,473.16L366.89,473.16L364.52,478.36L364.52,478.36L363.4,478.16L363.4,478.16L360.97,476.18L360.97,476.18L357.52,475.5L354.47,473.75L351.9,475.29L350.95,477.16L346.85,474.19L347.64,471.85L347.64,471.85L348.1,469.92L347.18,466.66L347.18,466.66L344.45,468.17L343.73,467.61L335.81,468.38L335.81,468.38L334.96,469.72L334.96,469.72L329.5,468.81L327.39,466.31L327.39,466.31L326.92,463.54L331.92,459.55L332.48,457.87L334.69,455.91L334.46,454.34L329.37,452.88L325.5,446.04L324.37,446.49L324.3,444.14L325.3,442.62L324.92,440.72L323.79,440.47L322.66,442.25L319.39,441.63L317.99,436.82L315.47,435.69L312.05,431.13L312.05,431.13L314.45,425.46L313.69,424.35L313.69,424.35L313.39,422.74L313.39,422.74L315.08,421.9L315.08,421.9L317.43,423.33L325.42,423.63L326.45,421.7L330.59,424.66L332.66,423.33L334.14,424.81L334.88,427.47L338.73,428.51L338.87,426.58L340.8,426.58L342.13,424.22L344.05,424.51L344.79,426.29L347.75,427.47L348.63,425.84L351.15,426.14L352.63,424.22L356.77,424.22L357.36,422.44L359.13,422.15L361.05,417.56L362.68,417.56L363.72,418.6L367.41,417.86L369.04,419.93L369.04,423.18L372.29,422.74L372.59,426.29L374.51,427.17L375.69,426.58L376.58,423.48L377.91,422L378.95,422L379.54,423.63L382.05,421.85L384.27,423.63L385.16,421.41L386.49,421.41L389.15,411.65L390.77,411.21L392.55,407.8L395.65,407.95L395.8,406.47L396.69,406.47L396.54,404.85z"
				},
				{
					"id":"IN-JK",
					"title":"Jammu and Kashmir",
					"d":"M198.68,162.25L200.24,164.1L202.1,162.61L204.55,162.87L202.24,164.94L202.13,166.08L203.17,169.74L204.84,171.41L204,172.74L207.39,182.38L210.47,183.54L211.02,184.66L213.98,184.45L222.43,191.36L221.92,194.2L216.79,197.8L218.1,199.09L216.9,201.49L218.38,205.23L216.8,207.7L219.19,212.26L222.58,215.59L224.01,216.74L226.83,216.82L226.55,219.41L224.84,221.44L228.16,225.5L227.4,238.06L225.31,237.99L224.96,239.31L223.82,239.03L222.35,240.01L221.06,239.42L218.23,236.6L217.6,231.46L215.13,233.62L211.59,234.28L210.73,235.72L210.73,235.72L208.78,237.54L208.23,237.04L210.23,232.72L210.04,230.26L206.96,232.48L204.79,232.72L203.32,234.27L202.3,233.99L200.75,229.76L196.68,224.23L189.55,228.17L184.54,226.44L178.62,221.1L176.32,220.05L169.94,219.79L160.53,226.9L158.79,225.81L157.06,226.35L159.62,230.59L159.8,233.57L158.23,235.59L158.23,235.59L155.09,238.58L152.71,239.23L151.1,241.97L150.11,239.99L147.13,239.96L147.13,239.96L141.49,236.4L140.32,237.47L137.36,236.3L134.55,236.57L133.4,233.52L134.53,227.97L133.4,228.38L132.83,229.96L131.13,230.37L129.79,229.39L128.72,226.41L126.75,226.02L127.4,223.67L124.44,223.01L122.52,220.06L120.52,219.24L120.64,217.76L122.34,217.47L123.73,215.61L124.06,212.95L122.19,210.13L120.81,210.03L119.33,206.46L121.57,204L124.73,202.85L125.62,200.21L124.63,198.63L122.76,198.22L120.35,199.02L117.83,198.35L119.74,193.04L118.16,190.69L115.37,190.7L115.65,189.3L119.16,185.41L119.03,182.83L120.49,182.02L123.13,182.48L126.53,179.77L127.93,179.69L132.13,180.52L134.65,182.43L138.91,182.68L141.13,183.71L145.87,183.57L148.49,185.92L156.12,186.83L162.01,183L164.5,183.67L170.99,179.91L175.25,180.78L176.51,178.78L176.64,176.62L179.11,175.48L181.73,176.31L182.15,173.83L185,173.43z"
				},
				{
					"id":"IN-KA",
					"title":"Karnataka",
					"d":"M193.81,558.79L193.5,561.03L195.33,565.86L192.1,568.73L191.33,573.11L195.42,575.96L193.09,576.92L189.77,581.55L191.14,586.93L191.44,594.83L189.4,597.17L186.87,597.7L188.97,599.17L192.18,599.45L193.8,600.94L191.75,601.96L192.2,608.59L184.94,608.09L182.21,610.51L184.11,614.97L182.74,614.9L181.49,617.7L185.04,623.08L185.36,625.29L184.38,627.55L183.08,628.17L177.27,626.89L176.57,629.06L178.95,629.66L178.97,631.44L178.59,632.86L177.41,633.42L176.95,636.58L179.04,639.38L181.26,639.71L179.27,641.87L180.73,644.6L183.82,645.24L185.51,642.71L189.77,643.66L190.19,642.46L192,643.92L192.17,646.4L190.56,646.08L189.01,647.07L190.89,651.53L190.18,651.93L189.19,651.52L188.19,648.98L184.9,649.49L182.65,648.39L182.21,645.79L179.98,646.33L182.88,651.09L181.47,653.12L181.92,655.03L185.42,654.51L185.75,652.41L190.67,652.85L191.24,655.43L194.9,654.99L195.31,654.01L198.07,653.57L198.49,650.81L201.31,650.5L201.36,651.86L204.89,652.38L204.36,656.87L207.13,658.28L210.54,658.06L210.1,663.46L213.34,664.88L214.06,664.05L214.07,666.62L211.93,669.87L212.31,673.32L209.94,671.76L207.49,675.26L207.49,675.26L201.21,674.01L200.46,672.83L198.47,673.78L197.02,677.27L194.75,677.12L193.97,679.29L194.38,681.21L195.04,680.84L194.62,683.57L191.82,685.65L191.8,687.09L196.76,687.48L197.5,689.25L195.11,692.33L191.49,693.55L190.95,696.46L187.3,695.37L179.92,695.64L178.67,699.93L174.44,699.68L171.79,697.29L170.38,698.17L170.38,698.17L166.84,694.94L163.99,694.07L163.64,691.55L161.56,692.5L158.15,691.98L157.19,690.12L152.53,687.66L150.33,684.84L149.45,685.09L148.25,681.72L140.26,674.89L137.77,675.59L137.77,675.59L132.93,653.02L130.44,648.52L127.92,640.07L128.68,639.33L127.36,637.65L126.45,638.55L125.3,634.29L122.23,632.92L122.3,631.24L122.3,631.24L126.81,629.13L126.7,622.85L127.91,622.42L126.7,618.55L126.79,614.81L125.03,614.25L124.07,614.86L123.7,614.29L124.76,613.17L124.76,613.17L129.04,612.2L129.12,609.64L130.61,608.84L131.75,605.47L132.02,602.85L128.75,601.14L128.32,600.14L129.04,599.2L128.53,597.82L127.1,597.41L127.49,596L134.92,594.54L137.36,591.98L140.21,591.25L140.73,587.71L143.88,588.2L146.1,590.09L148.84,586.55L154.56,586.96L154.55,581.66L153,578.25L153.85,577.1L157.03,578.1L158.68,577.1L159.82,579.04L165.17,578.46L168.98,579.42L169.83,578.32L169.14,578.04L168.18,573.31L171.39,571.68L172.51,569.74L175.38,571.42L180.08,566.51L180.8,563.74L180.26,561.39L181.55,560.75L183.91,562.11L186.64,556.59L189.31,555.46L190.28,556.64L189.59,558.43L191.36,559.31z"
				},
				{
					"id":"IN-KL",
					"title":"Kerala",
					"d":"M170.38,698.17l-1.33,1.4l-2.33,0.34l-0.46,2.42l2.66,0.56l3.71,2.23l-2.58,2.91l6.38,-0.49l0.35,3.33l-2.16,2.67l3.74,1.05l1.46,1.87l-1.46,4.01l0.04,6.2l2.79,1.58l4.39,-2.75l2.08,2.48l-2.35,12.98l3.83,0.17l0.87,1.3l-2.68,4.88l-0.6,2.93l-1.83,2.27l2.08,3.31l-1.6,2.99l1.97,3.7l-3.68,5.6l0,0l-10.61,-12l-0.09,-1.24l1.83,-0.61l0.07,-0.77l-2.66,0.8l-1.88,-3.68l-2.6,-6.62l-1.46,-10.29l0.86,2.69l1.45,1.13l-0.08,5.17l2.53,0.6l0.46,-0.68l-1.53,-1.4l-0.83,-5.43l-2.18,-2.24l-1.36,-3.31l0.52,2.99l-0.67,-1.06L154.77,703l-1.35,-0.63l-1.83,-4.78l-5.22,-6.4l-1.65,-0.05l-6.95,-15.55l0,0l2.49,-0.7l7.99,6.83l1.21,3.36l0.87,-0.25l2.21,2.82l4.66,2.46l0.96,1.86l3.41,0.52l2.08,-0.95l0.35,2.52l2.85,0.87L170.38,698.17zM151.89,696.77L151.89,696.77l-0.35,-0.74L151.89,696.77z"
				},
				{
					"id":"IN-LD",
					"title":"Lakshadweep",
					"d":"M95.16,708.23l-0.03,0.07l-0.12,-0.14l0.14,-0.8l0.21,-0.42L95.16,708.23zM82.88,715.94l-0.19,0.11l0.1,-0.55l0.1,-0.19l0.32,-0.47l0.06,0.15l-0.07,0.32L82.88,715.94zM92.27,721.41l-0.08,0.07l-0.14,-0.01l0.53,-0.47l-0.04,0.14L92.27,721.41zM112.95,731.46l-0.19,0.32l-0.12,-0.33l0.26,-0.58l0.08,0.25L112.95,731.46zM100.71,768.95l-0.37,0.12l-0.22,-0.31l1.2,-0.99l0.06,0.15l-0.18,0.58l-0.15,0.24L100.71,768.95z"
				},
				{
					"id":"IN-MH",
					"title":"Maharashtra",
					"d":"M248.82,549.29L245.17,549.65L243.23,547.69L241.84,542.01L240.51,542.32L240.51,540.85L242.12,539.46L242.68,534.21L239.14,530.28L237.69,530L234.36,532.03L227.28,528.65L222.69,529.57L220.24,528.08L220.88,527.03L219.87,526.48L210.54,525.35L210.47,526.82L209,528.13L209.36,532.78L206.62,533.8L206.78,537.2L204.53,537.66L202.28,535.47L200.62,536.17L201.01,537.47L199.07,541.67L199.56,543.57L201.67,545.84L201.01,546.85L198.6,547.47L196.87,549.69L197.18,553.34L194.89,553.16L193.53,555.35L193.81,558.79L193.81,558.79L191.36,559.31L189.59,558.43L190.28,556.64L189.31,555.46L186.64,556.59L183.91,562.11L181.55,560.75L180.26,561.39L180.8,563.74L180.08,566.51L175.38,571.42L172.51,569.74L171.39,571.68L168.18,573.31L169.14,578.04L169.83,578.32L168.98,579.42L165.17,578.46L159.82,579.04L158.68,577.1L157.03,578.1L153.85,577.1L153,578.25L154.55,581.66L154.56,586.96L148.84,586.55L146.1,590.09L143.88,588.2L140.73,587.71L140.21,591.25L137.36,591.98L134.92,594.54L127.49,596L127.1,597.41L128.53,597.82L129.04,599.2L128.32,600.14L128.75,601.14L132.02,602.85L131.75,605.47L130.61,608.84L129.12,609.64L129.04,612.2L124.76,613.17L124.76,613.17L123.51,612.84L122.3,614.32L122.48,615.35L121,616.14L117.24,611.58L115.41,613.1L114.01,613.17L114.01,613.17L112.92,612.8L112.25,610.17L108.89,606.04L106.4,596.96L107.1,596.4L105.24,589.14L105.34,584.26L101.95,569.56L99.94,564.82L99.03,558.15L97.53,555.67L96.83,547.51L98.21,546.99L99.45,548.99L99.56,547.64L97.9,544.9L100.82,543.02L99.08,541.42L96.08,545.01L95.05,544.29L96.1,542.14L95.17,536.42L96.63,536.23L100.58,538.57L98.91,536.43L95.64,536.03L94.65,535.07L92.82,524.29L94.12,518.61L94.12,518.61L94.12,518.61L94.12,518.61L96.27,518.96L97.61,516.93L99.3,517.7L99.3,517.7L99.39,518.93L100.96,520.24L103.66,520.49L104.7,518.98L104.7,518.98L104.71,518.98L104.71,518.98L104.71,518.98L104.71,518.98L105.4,519.42L108.14,517.64L109.9,509.87L108.68,508.02L109.67,506.6L109.67,506.6L109.98,506.95L109.98,506.95L113.73,509.66L116.64,508.76L118.98,505.65L119.11,504.01L116.56,498.94L116.56,498.94L116.56,498.94L116.56,498.94L113.6,498.24L113.6,498.24L113.6,498.24L113.6,498.24L112.24,496.04L114.29,496.82L116.12,496.01L119.29,493.64L120.02,491.1L122.02,489.76L125.94,489.55L126.8,487.77L126.8,487.77L126.8,487.77L126.8,487.77L121.22,487.71L117.48,489.07L117.48,489.07L117.48,489.07L117.48,489.07L116.25,486.24L118.43,485.51L117.57,481.21L121.03,479.38L125.82,479.25L127.12,478.33L127.12,478.33L130.96,476.73L129.85,477.28L129.26,480.5L131.88,483.25L139.55,484.57L142.39,487.77L142.39,487.77L147.21,489.73L147.21,489.73L159.41,490.46L159.41,490.46L162.4,490.54L163.59,494.36L163.26,495.92L164.27,496.93L167.01,497.35L167.01,497.35L168.71,496.69L168.71,496.69L170.54,495.03L173,494.91L173.64,491.36L176.56,488.74L176.56,488.74L176.51,486.17L178.06,485.54L178.06,485.54L179.38,485.59L181.85,483.68L181.85,483.68L182.89,482.57L184.44,482.49L184.44,482.49L186.03,483.57L191.3,482.48L191.3,482.48L192.96,484.66L193.57,487.35L190.11,487.25L191.38,490.27L193.07,491.08L196.85,490.95L196.85,490.95L199.09,490.35L200.23,490.98L200.23,490.98L205.43,488.56L205.43,488.56L206.25,487.12L208.48,486.49L208.48,486.49L209.27,486.32L209.27,486.32L211.04,486.5L211.04,486.5L215.99,489.03L221.95,488.05L221.95,488.05L222.18,486.34L222.18,486.34L225.35,485.78L228.02,484.07L228.02,484.07L228.6,483.06L231.04,484.67L231.04,484.67L232.36,484.44L232.36,484.44L234.11,484.52L234.03,486.84L235.32,487.67L236.87,487.37L236.87,487.37L238.67,485.9L240.32,486.18L241.99,487.74L244.67,487.47L247.81,485.04L247.81,485.04L249.58,485.07L249.58,485.07L253.3,490.63L257.79,491.59L257.79,491.59L258.45,491.79L258.45,491.79L255.99,494.13L255.99,494.13L253.65,496.29L254.3,500.81L254.3,500.81L255.27,500.56L255.27,500.56L256.32,506.47L255.18,507.07L255.18,507.07L254.67,507.8L254.67,507.8L255.56,508.65L256.93,508.35L256.93,508.35L257.25,513.63L257.25,513.63L252.84,516.25L252.88,518.32L252.88,518.32L256.13,518.14L255.82,521.74L255.82,521.74L254.46,522.91L254.46,522.91L252.62,526.1L253.71,526.62L253.71,526.62L254.74,526.44L255.21,525.25L255.21,525.25L258.63,528.08L258.63,528.08L258.19,529.93L258.19,529.93L263.29,532.31L262.07,535.74L258.7,538.36L255.79,536.24L255.22,534.62L255.22,534.62L253.26,535.93L253.26,535.93L251.54,537.77L251.54,537.77L250.13,541.41L250.13,541.41L249.59,542.41L249.59,542.41L249.13,544.88L249.13,544.88L250.65,546.88L248.43,548.32L248.43,548.32z"
				},
				{
					"id":"IN-ML",
					"title":"Meghalaya",
					"d":"M498.01,410.72L496.37,409.24L490.35,406.8L478.93,407.9L474.4,406.39L465.77,407.68L456.38,407.56L447.82,404.37L445.45,404.51L444.74,402.78L445.46,399.4L445.46,399.4L448.67,397.58L447.4,394.39L449.41,391.01L451.52,389.46L456.67,388.18L459.12,388.53L460.81,389.89L464.08,389.62L469.58,390.78L469.49,392.2L472.96,392.65L473.52,394.71L476.15,392.31L479.18,391.52L480.81,388.36L483.76,387.18L485.96,386.7L488.65,388.2L492.9,386.93L494.84,387.21L493.12,389.41L492.96,395.94L498.11,394.13L502.13,398.35L501.28,399.88L502.71,401.77L504.24,401.98L505.71,403.71L506.02,406.22L500.91,408.32z"
				},
				{
					"id":"IN-MN",
					"title":"Manipur",
					"d":"M544.16,401.38L542.45,406.32L545.39,407.88L545.67,410.31L543.27,416.42L540.27,420.43L537.03,427.06L533.62,436.77L528.74,434.44L526.95,434.9L525.79,433.45L524.22,433.11L520.33,434.29L518.03,431.51L516.79,432.65L516.79,432.65L512.6,432.39L509.78,431.03L510.62,424.73L510.62,424.73L511.75,417.58L515.61,413.3L517.75,407.19L519.4,405.56L519.4,405.56L521.36,406.04L521.58,407.42L522.14,407.04L526.13,400.76L525.6,399.44L530.87,398.94L532.82,399.88L538.17,399.92L542.22,395.94L542.93,396.1L542.33,400.34z"
				},
				{
					"id":"IN-MP",
					"title":"Madhya Pradesh",
					"d":"M210.19,369.67L213.28,371.02L213.28,371.02L215.09,370.68L215.09,370.68L217.67,370.55L217.67,370.55L222.5,373.78L222.5,373.78L225.18,378.38L225.18,378.38L225.19,382.91L222.18,385.9L222.31,388.23L222.31,388.23L220.56,393.14L215.16,398.58L215.16,398.58L212.27,398.59L209.01,402.72L211.16,407.08L211.16,407.08L210.79,408.75L210.79,408.75L209.54,412.08L207.4,413.63L207.4,413.63L206.3,414.67L206.3,414.67L207.69,418.12L207.69,418.12L207.84,422.94L207.84,422.94L207.3,423.64L209.95,424.86L210.08,425.88L210.08,425.88L211.47,426.51L212.6,425.1L212.6,425.1L215.75,427.51L215.75,427.51L219.03,429.15L219.03,429.15L223.04,425.05L221.39,420.47L221.39,420.47L220.89,419.83L218.63,420.74L217.74,419.85L217.73,414.61L216.08,412.44L216.08,412.44L213.42,403.86L216.56,401.4L216.56,401.4L217.06,401.78L217.06,401.78L216.31,402.62L217.44,403.45L218.2,403.58L218.7,402.16L218.7,402.16L220.83,398.81L222.09,399.45L222.48,402.27L220.46,402.8L219.96,403.96L220.73,407.8L223.49,404.84L223.49,404.84L224.13,408.3L226.65,409.06L229.42,408.53L229.42,408.53L230.04,406.35L230.04,406.35L228.4,405.46L228.4,405.46L228.27,404.17L228.27,404.17L229.78,403.91L232.31,406.21L230.8,408.27L232.06,409.42L233.2,409.54L234.7,407.74L239.99,409.63L240.36,406.94L240.36,406.94L244.26,403.84L248.91,402.28L249.69,403.02L249.69,403.02L251.91,407.1L248.43,409.98L249.56,411.51L249.56,411.51L252.08,411.24L252.08,411.24L254.09,409.95L257.87,410.06L257.87,410.06L258.88,410.06L257.36,408.4L261.26,407.48L261.26,407.48L259.26,412.62L259.26,412.62L261.53,412.48L261.53,412.48L264.55,412.47L265.56,413.49L267.7,413.09L268.75,407.64L272.47,408.2L272.47,408.2L273.34,407.04L275.23,407.03L275.62,409.85L278.89,411.38L281.54,410.98L282.55,414.69L287.21,415.69L290.12,418.87L290,420.02L290,420.02L291.63,420.27L291.63,420.27L291.62,417.46L293.01,418.09L293.01,418.09L294.27,418.72L296.54,418.07L296.54,418.07L297.61,418L298.93,419.72L297.68,421L297.68,421L298.57,425.21L298.57,425.21L298.39,429.73L298.39,429.73L297.26,429.61L297.26,429.61L300.23,433.98L300.23,433.98L300.76,434.38L300.76,434.38L298.8,435.09L298.06,437.6L296.58,437.45L295.7,439.52L294.66,438.19L289.49,438.04L287.12,436.71L281.5,437.16L278.25,435.23L277.21,436.27L278.99,438.63L276.62,442.04L277.07,443.22L278.1,444.25L281.21,443.51L282.24,444.7L282.98,443.96L284.31,446.03L285.35,445.88L288.16,449.28L287.86,453.27L284.02,454.16L282.83,455.49L282.39,458.15L280.47,460.37L280.62,462.29L277.66,463.62L277.51,464.96L275,465.55L274.11,466.73L272.19,465.99L268.93,467.17L267.31,466.88L267.46,471.17L265.83,471.31L264.94,473.09L265.68,473.68L265.39,475.6L263.02,475.01L262.87,477.67L261.25,478.11L261.84,483.14L259.17,483.88L260.06,488.32L258.25,491.73L258.25,491.73L257.79,491.59L257.79,491.59L253.3,490.63L249.58,485.07L249.58,485.07L247.81,485.04L247.81,485.04L244.67,487.47L241.99,487.74L240.32,486.18L238.67,485.9L236.87,487.37L236.87,487.37L235.32,487.67L234.03,486.84L234.11,484.52L232.36,484.44L232.36,484.44L231.04,484.67L231.04,484.67L228.6,483.06L228.02,484.07L228.02,484.07L225.35,485.78L222.18,486.34L222.18,486.34L221.95,488.05L221.95,488.05L215.99,489.03L211.04,486.5L211.04,486.5L209.27,486.32L209.27,486.32L208.48,486.49L208.48,486.49L206.25,487.12L205.43,488.56L205.43,488.56L200.23,490.98L200.23,490.98L199.09,490.35L196.85,490.95L196.85,490.95L193.07,491.08L191.38,490.27L190.11,487.25L193.57,487.35L192.96,484.66L191.3,482.48L191.3,482.48L186.03,483.57L184.44,482.49L184.44,482.49L182.89,482.57L181.85,483.68L181.85,483.68L179.38,485.59L178.06,485.54L178.06,485.54L176.51,486.17L176.56,488.74L176.56,488.74L173.64,491.36L173,494.91L170.54,495.03L168.71,496.69L168.71,496.69L167.01,497.35L167.01,497.35L164.27,496.93L163.26,495.92L163.59,494.36L162.4,490.54L159.41,490.46L159.41,490.46L147.21,489.73L147.21,489.73L142.39,487.77L142.39,487.77L139.55,484.57L131.88,483.25L129.26,480.5L129.85,477.28L130.96,476.73L127.12,478.33L127.12,478.33L123.99,479.52L122.63,478.89L122.63,478.89L121.53,475.41L122.52,473.59L122.52,473.59L120.78,468.91L120.78,468.91L120.96,466.73L120.96,466.73L121.95,467.6L121.95,467.6L124.94,466.73L124.94,466.73L123.94,465.55L122,466.07L120.31,464.46L120.57,463.23L120.57,463.23L127.49,460.83L129.99,455.88L129.84,454.99L127.95,455.49L127.95,455.49L127.13,451.78L128.29,450.73L129.63,451.23L129.63,451.23L133.12,449.71L133.12,449.71L131.31,448.54L131.31,448.54L131.47,446.81L131.47,446.81L132.72,444.9L137.87,442.6L139.13,441.2L139.13,441.2L140.13,437.77L139.49,434.73L141.11,431.42L141.11,431.42L139.98,429.9L139.98,429.9L138.83,426.34L136.82,426.6L136.44,425.96L139.07,422.13L136.18,420.87L137.93,417.66L137.93,417.66L138.81,416.25L139.57,417.66L139.57,417.66L140.2,418.04L140.2,418.04L141.83,417.52L142.21,416.49L142.21,416.49L142.08,414.96L142.08,414.96L139.93,414.58L139.93,414.58L138.54,411.78L138.54,411.78L139.04,410.49L139.04,410.49L139.93,411.51L139.93,411.51L142.7,413.29L144.59,413.03L144.96,411.62L144.96,411.62L146.21,409.3L146.21,409.3L149.42,409.35L148.48,411.09L148.48,411.09L147.48,411.22L147.99,413.01L147.99,413.01L150.63,413.51L149.63,414.16L149.63,414.16L148.49,414.8L147.36,413.53L146.36,415.83L146.36,415.83L151.52,417.34L151.52,417.34L158.32,416.29L158.32,416.29L158.83,419.23L158.83,419.23L160.47,420.5L160.22,421.65L160.22,421.65L156.83,424.21L156.83,424.21L157.73,431.72L157.73,431.72L156.6,433.51L156.6,433.51L155.59,432.75L152.45,433.14L150.69,434.8L151.7,435.18L151.7,435.18L155.48,438.59L156.36,436.68L157.87,435.91L157.87,435.91L160.89,435.14L161.89,432.21L161.89,432.21L163.9,430.93L164.52,429.4L164.52,429.4L165.21,426.86L169.43,427.85L169.43,427.85L173.33,428.59L175.34,427.06L175.34,427.06L176.47,427.05L176.36,429.85L178.12,430.86L179.76,430.6L179.76,430.6L180.38,429.2L179.12,426.66L179.1,421.05L179.1,421.05L180.74,421.42L181.5,423.21L182.38,422.95L182.87,419.33L182.87,419.33L180.72,416.66L180.72,416.66L179.47,416.95L179.47,416.95L178.55,416.56L178.83,415.04L180.84,414.39L180.84,414.39L180.46,412.35L180.46,412.35L179.95,410.56L179.95,410.56L180.58,409.66L182.09,410.03L186.62,408.73L186.62,408.73L189.01,409.23L189.01,409.23L191.02,406.66L191.02,406.66L190.12,402.04L189.49,401.4L188.11,402.05L188.11,402.05L187.11,403.98L178.8,403.89L178.8,403.89L173.63,400.45L173.63,400.45L173.87,396.71L173.87,396.71L173.73,391.17L173.73,391.17L177.57,389.3L177.89,388.19L185.92,383.03L185.92,383.03L188.97,380.14L188.97,380.14L189.62,380.17L189.62,380.17L198.52,375.79L198.52,375.79L198.83,375.45L198.83,375.45L200.19,373.42L203.98,371.89L204.27,370.62L204.27,370.62L206.82,369.63L206.82,369.63L208.1,368.94L208.1,368.94z"
				},
				{
					"id":"IN-MZ",
					"title":"Mizoram",
					"d":"M510.62,424.73L509.78,431.03L512.6,432.39L516.79,432.65L516.79,432.65L518.74,440.98L518.03,450.57L516.33,455.31L512.93,454.66L511.97,462.02L514.13,471.95L513.26,473.65L511.03,473.28L509.88,476.71L508.52,477.67L504.04,474.38L503.42,477.23L501.88,478.17L500.02,461.76L497.25,457.05L496.73,450.62L497.49,449.36L495.06,439.71L495.06,439.71L496.28,433.6L495.83,428.37L495.83,428.37L498.42,428.39L498.55,430.25L499.64,430.47L502.57,428.07L505.18,422.18L507.06,425.28z"
				},
				{
					"id":"IN-NL",
					"title":"Nagaland",
					"d":"M539.21,375.23L539.21,375.23L545.67,375.79L552.46,379.54L552.46,379.54L552.75,383.09L554.49,387.58L552.48,389.64L551.03,394.49L548.75,397.97L544.16,401.38L544.16,401.38L542.33,400.34L542.93,396.1L542.22,395.94L538.17,399.92L532.82,399.88L530.87,398.94L525.6,399.44L526.13,400.76L522.14,407.04L521.58,407.42L521.36,406.04L519.4,405.56L519.4,405.56L518.62,405.09L519.04,402.01L516.48,398.99L520.05,396.31L524.2,390.23L526.01,390.01L526.14,392.88L529.85,391.44L530.62,385.01L530.62,385.01L534.21,379.83L534.21,379.83L536.14,375.88L537.29,378.3L539.21,375.51z"
				},
				{
					"id":"IN-OR",
					"title":"Odisha",
					"d":"M380.69,473.16L380.98,473.99L387.12,476.32L386.78,479.11L387.65,480.24L388.7,480.23L390.01,477.9L391.62,478.32L391.46,479.95L392.58,481.28L396.19,482.72L396.83,486.31L396.83,486.31L389.31,488.55L384.5,493.57L383.59,497.46L386.18,503.7L384.73,504.96L385.71,506.29L387.48,506.8L381.95,510.8L381.17,512.95L382.9,512.05L382.89,513.14L379.81,516.19L376.45,517.64L375.08,521.81L370.47,519.86L373.73,522.23L369.68,524.27L355.18,528.85L354.77,528.12L357.19,527.29L357.72,525.05L355.34,523.58L350.82,527.11L348.49,532.16L349.22,532.21L351.04,529.08L353.73,528.5L354.29,528.83L353.77,529.88L351.93,530.21L352.69,530.78L343.47,538.19L341.62,540.58L340.31,540.45L340.31,540.45L337.02,539.49L331.23,546.85L326.88,547.62L325.12,546.73L323.27,547.33L321.11,546.74L321.2,543.05L320.22,542.16L319.93,543.16L317.48,539.12L316.36,539.68L315.14,542.18L313.58,543.08L311.77,542.19L310.94,543L313,545.28L312.22,546.28L309.88,547.59L307.24,547.4L305.2,550L306.47,552.78L306.14,555.62L303.74,556.38L301.59,554.99L297.01,559.19L294.9,553.73L293.09,553.19L291.72,554.93L290.37,560.11L291.16,562.69L289.4,564.68L286.47,562.91L279.63,566.31L278.66,568L274.66,569.01L274.66,569.01L276.15,567.05L276.15,567.05L276.81,565.52L276.81,565.52L277.76,560.03L282.08,556.89L282.08,556.89L285.69,552.4L285.41,550.77L285.41,550.77L290.64,547.38L292.07,544.88L291.36,540.81L291.36,540.81L290.53,537.47L290.84,533.87L287.75,531.86L287.75,527.45L287.75,527.45L287.65,525.69L285.65,524.04L285.65,524.04L283.85,522.97L283.85,522.97L283.76,520.08L285.53,518.81L286.14,519.43L286.14,519.43L287.33,520.63L287.33,520.63L291.14,521L291.14,521L291.8,520.93L291.8,520.93L294.87,524.71L294.87,524.71L299.12,524.32L299.12,524.32L299.69,525.7L299.69,525.7L301.96,523.99L301.96,523.99L301.01,520.5L299.33,521.22L295.22,519.28L295.22,519.28L295.33,515.66L295.33,515.66L295.59,513.61L295.59,513.61L295.13,511.71L295.13,511.71L293.45,502.3L293.45,502.3L293.49,501.38L293.49,501.38L295.25,502.29L295.25,502.29L296.75,502.32L297.31,499.54L299.83,495.32L299.83,495.32L309.67,495.77L311.04,494.54L311.04,494.54L312.59,490.46L314.88,490.87L315.11,488.52L315.11,488.52L313.92,486.79L316.66,483.79L316.66,483.79L316.77,480.68L316.77,480.68L317.85,480.43L317.85,480.43L318.86,479.22L318.35,477.03L318.35,477.03L317.82,475.63L318.63,473.02L319.88,471.05L321.5,470.87L321.5,470.87L324.3,468.26L326.05,468.18L326.05,468.18L327.39,466.31L327.39,466.31L327.39,466.31L327.39,466.31L329.5,468.81L334.96,469.72L334.96,469.72L335.81,468.38L335.81,468.38L343.73,467.61L344.45,468.17L347.18,466.66L347.18,466.66L348.1,469.92L347.64,471.85L347.64,471.85L346.85,474.19L350.95,477.16L351.9,475.29L354.47,473.75L357.52,475.5L360.97,476.18L360.97,476.18L363.4,478.16L363.4,478.16L364.52,478.36L364.52,478.36L366.89,473.16L366.89,473.16L366.83,468.49L366.04,467.1L366.04,467.1L365.58,466.1L365.58,466.1L367.35,465.16L367.35,465.16L368.47,466.02L368.47,466.02L370.7,466.94L370.7,466.94L372.21,467.53L373.86,469.79L373.86,469.79L374.45,470.19L374.45,470.19L375.7,470.25L375.7,470.25L378.13,470.64L378.13,470.64z"
				},
				{
					"id":"IN-PY",
					"title":"Puducherry",
					"d":"M290.24,592.02l-0.97,-0.05l0,0l-0.4,-1.24l1.83,1.17l0,0L290.24,592.02zM240.68,690.55l-0.24,1.01l0,0l-0.43,-0.67L240.68,690.55zM236.99,691.45l-0.54,-0.24l0.67,-0.47L236.99,691.45zM235.91,692.03l-0.43,-1.03l0,0l0.47,-0.19l0,0L235.91,692.03zM240.15,692.62l-0.61,1.9l0,0l-2.85,-0.85l1.32,-2.27L240.15,692.62zM236.26,694.63l-0.69,0.03l0,0l-0.39,-0.68L236.26,694.63zM239.32,695.14l-0.37,1.24l0,0l-1.33,-0.53l0.21,-0.86L239.32,695.14zM151.94,696.47l-0.04,0.3l0,0l-0.35,-0.74l0,0L151.94,696.47zM240.31,712.4l-0.24,3.54l0,0l-2.51,-2.49l1.7,-1.58L240.31,712.4z"
				},
				{
					"id":"IN-PB",
					"title":"Punjab",
					"d":"M177.52,274.51L178.54,277.52L178.54,277.52L176.79,277.33L175.43,278.54L177.43,280.31L178.21,279.82L178.21,279.82L180.18,282.22L179.84,287.63L179.06,287.63L178.65,286.05L176.23,286.24L176.07,287.65L173.85,290.22L174.71,291.35L174.21,292.6L172.32,294.12L166.78,292.92L165.83,296.06L166.34,299.13L162.42,301.94L158.92,301.76L157.08,300.07L152.76,301.85L150.13,300.46L147.42,303.59L147.03,305.95L145.57,306.42L144.14,303.65L145.47,301.72L144.75,299.69L140.73,298.87L136.99,296L133.38,297.73L130.71,296.93L130.71,296.93L116.99,296.38L119.1,292.12L119.1,292.12L119.36,289.75L117.58,287.07L118.9,284.98L120.92,283.25L121.82,283.41L122.09,281.43L126.01,278.64L125.6,277.75L126.71,275.86L127.67,275.9L127.72,274.96L131.27,272.38L131.68,270.62L133,271.11L134.47,269.95L132.98,268.96L131.55,270.19L130.58,268.93L130.71,265.73L133.4,261.25L131.83,260.25L132.55,258.66L130.84,254.94L131.64,252.4L134.78,249.29L136.83,249.36L138.13,247.06L139.22,246.7L140.84,247.59L143.13,246.29L144.12,246.64L144.75,245.47L145.65,246.18L148.19,242.62L147.13,239.96L147.13,239.96L150.11,239.99L151.1,241.97L152.71,239.23L155.09,238.58L158.23,235.59L158.23,235.59L160.57,238.5L158.92,240.59L154.63,242.22L154.1,243.32L155.01,246.59L160.48,250.83L161.25,252.44L160.39,253.1L164.81,261.98L165.32,264.92L167.53,264.86L168.4,263.42L170.04,263.37L170.76,264.88L174.45,267.8L174.22,272.12z"
				},
				{
					"id":"IN-RJ",
					"title":"Rajasthan",
					"d":"M119.1,292.12L116.99,296.38L130.71,296.93L130.71,296.93L130.5,299.54L129.35,301.18L130.62,301.87L132.35,301.27L131.75,306.16L132.63,306.84L130.94,308.49L132.13,311.16L137.27,309.82L138.58,310.31L139.32,312.43L141.99,313.6L148.87,313.43L148.66,317.81L151.41,319.8L150.45,321.21L152.04,327.49L155.22,331.29L159.64,334.26L163.18,339.1L161.79,338.79L159.86,340.36L160.92,346.26L164.46,346.57L165.45,345.6L164.56,342.23L165.03,341.25L166.53,341.08L167.92,342.02L168.42,338.77L171.14,339.55L170.34,340.02L170.7,341.58L172.81,343.54L174.74,340.42L178.95,337.34L181.07,339.24L179.93,350.11L181.56,349.94L181.78,348.95L185.39,346.65L186.82,347.21L188.5,346.28L188.5,346.28L188.25,348.56L191.1,356.76L195.55,360.3L195.49,361.96L195.49,361.96L192.78,363.65L192.78,363.65L192.18,364.11L193.61,365.21L197.21,365.46L197.27,366.31L191.13,368.84L190.99,371.79L190.99,371.79L196.78,368.19L196.78,368.19L199.08,367.92L199.08,367.92L202.36,368.5L204.93,367.33L204.93,367.33L207.55,367.46L207.55,367.46L207.21,368.62L207.21,368.62L206.82,369.63L206.82,369.63L204.27,370.62L204.27,370.62L203.98,371.89L200.19,373.42L198.83,375.45L198.83,375.45L198.52,375.79L198.52,375.79L189.62,380.17L189.62,380.17L188.97,380.14L188.97,380.14L185.92,383.03L185.92,383.03L177.89,388.19L177.57,389.3L173.73,391.17L173.73,391.17L173.87,396.71L173.87,396.71L173.63,400.45L173.63,400.45L178.8,403.89L178.8,403.89L187.11,403.98L188.11,402.05L188.11,402.05L189.49,401.4L190.12,402.04L191.02,406.66L191.02,406.66L189.01,409.23L189.01,409.23L186.62,408.73L186.62,408.73L182.09,410.03L180.58,409.66L179.95,410.56L179.95,410.56L180.46,412.35L180.46,412.35L180.84,414.39L180.84,414.39L178.83,415.04L178.55,416.56L179.47,416.95L179.47,416.95L180.72,416.66L180.72,416.66L182.87,419.33L182.87,419.33L182.38,422.95L181.5,423.21L180.74,421.42L179.1,421.05L179.1,421.05L179.12,426.66L180.38,429.2L179.76,430.6L179.76,430.6L178.12,430.86L176.36,429.85L176.47,427.05L175.34,427.06L175.34,427.06L173.33,428.59L169.43,427.85L169.43,427.85L165.21,426.86L164.52,429.4L164.52,429.4L163.9,430.93L161.89,432.21L161.89,432.21L160.89,435.14L157.87,435.91L157.87,435.91L156.36,436.68L155.48,438.59L151.7,435.18L151.7,435.18L150.69,434.8L152.45,433.14L155.59,432.75L156.6,433.51L156.6,433.51L157.73,431.72L157.73,431.72L156.83,424.21L156.83,424.21L160.22,421.65L160.22,421.65L160.47,420.5L158.83,419.23L158.83,419.23L158.32,416.29L158.32,416.29L151.52,417.34L151.52,417.34L146.36,415.83L146.36,415.83L147.36,413.53L148.49,414.8L149.63,414.16L149.63,414.16L150.63,413.51L147.99,413.01L147.99,413.01L147.48,411.22L148.48,411.09L148.48,411.09L149.42,409.35L146.21,409.3L146.21,409.3L144.96,411.62L144.96,411.62L144.59,413.03L142.7,413.29L139.93,411.51L139.93,411.51L139.04,410.49L139.04,410.49L138.54,411.78L138.54,411.78L139.93,414.58L139.93,414.58L142.08,414.96L142.08,414.96L142.21,416.49L142.21,416.49L141.83,417.52L140.2,418.04L140.2,418.04L139.57,417.66L139.57,417.66L138.81,416.25L137.93,417.66L137.93,417.66L136.18,420.87L139.07,422.13L136.44,425.96L136.82,426.6L138.83,426.34L139.98,429.9L139.98,429.9L141.11,431.42L141.11,431.42L139.49,434.73L140.13,437.77L139.13,441.2L139.13,441.2L137.87,442.6L132.72,444.9L131.47,446.81L131.47,446.81L131.31,448.54L131.31,448.54L133.12,449.71L133.12,449.71L129.63,451.23L129.63,451.23L127.56,451.09L127.61,454.15L126.6,453.57L126.6,453.57L125.49,451.6L123.28,451.82L123.07,450.13L123.07,450.13L119.94,447.88L119.14,448.49L118.03,447.81L118.03,447.81L116.71,446.24L116.71,446.24L112.79,445.58L112.79,445.58L112.79,445.58L112.79,445.58L113.28,443.19L112.47,442.01L112.47,442.01L111.16,441.92L110.15,439.94L107.53,438.57L107.53,438.57L106.92,436.99L108.42,435.37L107.9,432.28L107.9,432.28L107.9,432.28L107.9,432.28L106.99,431.29L104.58,433.22L101.56,430.16L101.56,430.16L101.56,430.16L101.56,430.16L101.25,428.86L102.65,426.24L101.82,422.44L101.82,422.44L101.82,422.44L101.82,422.44L99.41,422.77L98.11,425.29L94.59,425.53L93.38,424.75L93.38,424.75L92.77,423.45L92.77,423.45L84.32,421.15L84.32,421.15L84.32,421.15L84.32,421.15L84.31,419.65L84.31,419.65L81.89,419.77L81.29,418.58L81.29,418.58L79.37,417.99L72.44,419.28L68.91,418.22L63.99,419.69L60.63,418.44L57.55,412.5L56.5,407.78L52.06,401.94L51.82,395.29L44.67,395.39L40.67,390.45L40.1,386.46L41.73,382.79L41.6,375.76L39.51,374.78L34.36,374.94L28.13,371.36L28.14,365.63L29.67,361.54L38.49,352.85L41.37,346.44L45.67,342.42L48.61,341.78L49.86,342.31L51.81,344.41L53.39,348.88L56.29,349.57L64.27,346.26L72.18,345.63L77.08,343.59L77.82,339.67L82.97,334.32L85.38,327.19L87.08,324.88L98.51,318.74L105.27,306.34L107.86,297.29L115.86,294.36L119.34,291.56z"
				},
				{
					"id":"IN-SK",
					"title":"Sikkim",
					"d":"M420.51,340.01L424.57,342.38L425.48,345.48L424.83,349.6L423.17,353.16L423.89,356.06L426.3,358.34L424.11,359.77L422.93,362.22L422.93,362.22L419.58,361.69L416.45,364.07L407.7,362.15L407.7,362.15L408.64,353.37L411.32,347.63L411.34,346.09L409.98,344.75L410.31,343.78L415.48,343.11z"
				},
				{
					"id":"IN-TN",
					"title":"Tamil Nadu",
					"d":"M245.77,660l2.92,0.72l1.79,2.57l-1.9,11.92l-1.97,6.26l-5.94,9.07l0,0l-0.67,0.34l0.43,0.67l0,0l-0.29,1.07l0,0l-2.14,-1.22l-1.32,2.27l2.85,0.85l0,0l-0.22,0.61l0,0l-1.48,-0.15l-0.21,0.86l1.33,0.53l0,0l-0.73,4.24l1.62,4.43l0.46,7.35l0,0l-1.06,-0.53l-1.7,1.58l2.51,2.49l0,0l0.35,11.03l-3.58,-0.4l1.72,0.86l-1.16,-0.05l-6.52,-1.08l-1.42,0.79l-1.69,2.01l0.17,3.43l-5.5,7.3l-1.5,3.93l2.05,2.94l6.62,1.4l2.35,2.15l-3.11,-1.79l-6.7,-0.55l-11.45,3.64l-4.46,3.98l-1.29,8.71l-1.39,2.38l-5.62,3.5l-4.29,1.38l-0.88,1.17l-4.86,-1.26l-4.23,-3.33l0,0l3.68,-5.6l-1.97,-3.7l1.6,-2.99l-2.08,-3.31l1.83,-2.27l0.6,-2.93l2.68,-4.88l-0.87,-1.3l-3.83,-0.17l2.35,-12.98l-2.08,-2.48l-4.39,2.75l-2.79,-1.58l-0.04,-6.2l1.46,-4.01l-1.46,-1.87l-3.74,-1.05l2.16,-2.67l-0.35,-3.33l-6.38,0.49l2.58,-2.91l-3.71,-2.23l-2.66,-0.56l0.46,-2.42l2.33,-0.34l1.33,-1.4l0,0l1.41,-0.88l2.65,2.39l4.23,0.25l1.25,-4.29l7.38,-0.27l3.65,1.09l0.53,-2.91l3.63,-1.22l2.38,-3.07l-0.74,-1.77l-4.96,-0.39l0.02,-1.44l2.8,-2.08l0.42,-2.73l-0.67,0.37l-0.41,-1.92l0.78,-2.17l2.27,0.14l1.45,-3.48l2,-0.96l0.75,1.18l6.28,1.25l0,0l0.55,1.65l3.76,1.38l3.22,-4l0.01,-3.79l2.39,-1.59l3.27,-0.43l4.26,1.38l7.21,-3.45l-0.11,-1.92l-1.19,-0.36l1.8,-0.63l5.58,2.93l6.02,-6.62L245.77,660zM235.95,690.81L235.95,690.81l-0.16,1.33l-0.31,-1.14L235.95,690.81zM235.57,694.66L235.57,694.66l-0.39,-0.68l1.08,0.66L235.57,694.66z"
				},
				{
					"id":"IN-TR",
					"title":"Tripura",
					"d":"M495.83,428.37L496.28,433.6L495.06,439.71L495.06,439.71L493.14,439.32L490.22,441.35L488.7,439.53L488.86,444.47L485.11,448.77L485.82,453.7L483.91,455.82L481.58,456.93L480.56,456.02L477.77,449.89L476.82,450.84L477.23,454.15L476.35,453.9L474.26,445.67L472.35,441.67L472.25,439.57L473.43,438.9L474.54,434.15L476.87,431.1L480.24,431.51L484.46,430L487.14,430.07L487.93,426.13L488.45,425.64L489.15,426.29L491.95,424.73L492.44,421.67L492.44,421.67L494.64,423.45L494.96,425.65L493.96,428.45z"
				},
				{
					"id":"IN-UP",
					"title":"Uttar Pradesh",
					"d":"M337.71,393.89L337.71,393.89L337.49,394.84L337.49,394.84L335.35,395.79L333.66,395.2L333.66,395.2L327.44,394.88L327.44,394.88L325.46,397.28L325.46,397.28L321.61,400.43L321.61,400.43L320.43,401.77L314.49,404.02L314.49,404.02L313.57,404.54L313.57,404.54L312.26,406.08L311.3,409.97L311.3,409.97L314.98,416.74L314.98,416.74L316.37,419.74L316.37,419.74L315.82,421.48L315.82,421.48L313.39,422.74L313.39,422.74L313.69,424.35L313.69,424.35L314.45,425.46L312.72,429.86L312.05,431.13L308.91,432.54L308.67,434.2L308.67,434.2L308.29,435.09L308.29,435.09L304.14,436L304.14,436L301.24,434.74L301.24,434.74L300.23,433.98L300.23,433.98L297.26,429.61L297.26,429.61L298.39,429.73L298.39,429.73L298.57,425.21L298.57,425.21L297.68,421L297.68,421L298.93,419.72L297.61,418L296.54,418.07L296.54,418.07L294.27,418.72L293.01,418.09L293.01,418.09L291.62,417.46L291.63,420.27L291.63,420.27L290,420.02L290,420.02L290.12,418.87L287.21,415.69L282.55,414.69L281.54,410.98L278.89,411.38L275.62,409.85L275.23,407.03L273.34,407.04L272.47,408.2L272.47,408.2L268.75,407.64L267.7,413.09L265.56,413.49L264.55,412.47L261.53,412.48L261.53,412.48L259.26,412.62L259.26,412.62L261.26,407.48L261.26,407.48L257.36,408.4L258.88,410.06L257.87,410.06L257.87,410.06L254.09,409.95L252.08,411.24L252.08,411.24L249.56,411.51L249.56,411.51L248.43,409.98L251.91,407.1L249.69,403.02L249.69,403.02L248.91,402.28L244.26,403.84L240.36,406.94L240.36,406.94L239.99,409.63L234.7,407.74L233.2,409.54L232.06,409.42L230.8,408.27L232.31,406.21L229.78,403.91L228.27,404.17L228.27,404.17L228.4,405.46L228.4,405.46L230.04,406.35L230.04,406.35L229.42,408.53L229.42,408.53L226.65,409.06L224.13,408.3L223.49,404.84L223.49,404.84L220.73,407.8L219.96,403.96L220.46,402.8L222.48,402.27L222.09,399.45L220.83,398.81L218.7,402.16L218.7,402.16L218.2,403.58L217.44,403.45L216.31,402.62L217.06,401.78L217.06,401.78L216.56,401.4L216.56,401.4L213.42,403.86L216.08,412.44L216.08,412.44L217.73,414.61L217.74,419.85L218.63,420.74L220.89,419.83L221.39,420.47L221.39,420.47L223.04,425.05L219.03,429.15L219.03,429.15L215.75,427.51L215.75,427.51L212.6,425.1L212.6,425.1L211.47,426.51L210.08,425.88L210.08,425.88L209.95,424.86L207.3,423.64L207.84,422.94L207.84,422.94L207.69,418.12L207.69,418.12L206.3,414.67L206.3,414.67L207.4,413.63L207.4,413.63L209.54,412.08L210.79,408.75L210.79,408.75L211.16,407.08L211.16,407.08L209.01,402.72L212.27,398.59L215.16,398.58L215.16,398.58L220.56,393.14L222.31,388.23L222.31,388.23L222.18,385.9L225.19,382.91L225.18,378.38L225.18,378.38L222.5,373.78L222.5,373.78L217.67,370.55L217.67,370.55L215.09,370.68L215.09,370.68L213.28,371.02L213.28,371.02L210.19,369.67L210.19,369.67L208.1,368.94L208.1,368.94L206.82,369.63L206.82,369.63L207.21,368.62L207.21,368.62L207.55,367.46L207.55,367.46L204.93,367.33L204.93,367.33L202.36,368.5L199.08,367.92L199.08,367.92L196.78,368.19L196.78,368.19L190.99,371.79L190.99,371.79L191.13,368.84L197.27,366.31L197.21,365.46L193.61,365.21L192.18,364.11L192.78,363.65L192.78,363.65L195.49,361.96L195.49,361.96L195.55,360.3L191.1,356.76L188.25,348.56L188.5,346.28L188.5,346.28L192.34,342.92L191.33,340.22L192.54,336.72L191.91,333.62L189.09,330.92L189.09,330.92L186.86,328.19L185.56,323.01L185.56,323.01L185.77,319.77L184.47,316.8L184.38,300.67L184.38,300.67L185.28,300.53L185.88,297.24L185.88,297.24L189.31,293.73L189.31,293.73L192.57,291.47L193.63,288.48L193.63,288.48L195.43,290.04L200,291.61L197.86,292.36L196.74,296.72L195.14,298.56L196.21,303.79L200.41,303.11L200.12,305.48L202.78,306.71L203.61,304.6L205.03,304.26L205.98,302.5L209.6,301.82L212.44,305.55L220.5,310.84L217.24,312.86L218.67,315.36L220.21,315.97L220.44,317.32L224.77,317.19L225.54,319.82L231.17,321.97L231.94,323.39L240.41,323.25L240.18,325.27L241.24,325L243.08,326.81L245.16,326.75L246.6,324.28L246.6,324.28L253.02,328.93L254.44,326.71L262.42,332.28L267.82,334.11L269.97,338.81L271.53,338.76L282.34,345.96L283.74,344.61L285.26,344.49L293.18,350.05L298.75,349.27L300.1,354.06L308.51,355.36L311.25,357.9L312.62,357.01L313.47,354.76L317.36,354.85L322.5,357.54L322.23,358.13L322.23,358.13L325.01,360.72L326.76,367.56L326.76,367.56L328.49,369.29L328.49,369.29L330.32,368.33L330.77,370.26L330.77,370.26L333.84,373.13L333.84,373.13L333.89,374.51L328.76,374.14L327.6,374.27L327.3,375.21L327.3,375.21L326.88,376.31L325.75,376.28L325.75,376.28L325.35,376.09L325.35,376.09L324,376.36L323.93,377.49L323.93,377.49L329.34,380.22L329.35,382.53L329.35,382.53L326.27,383.71L326.69,385.43L329.06,388.6L335.93,391.95z"
				},
				{
					"id":"IN-UT",
					"title":"Uttarakhand",
					"d":"M246.6,324.28L246.6,324.28L245.16,326.75L243.08,326.81L241.24,325L240.18,325.27L240.41,323.25L231.94,323.39L231.17,321.97L225.54,319.82L224.77,317.19L220.44,317.32L220.21,315.97L218.67,315.36L217.24,312.86L220.5,310.84L212.44,305.55L209.6,301.82L205.98,302.5L205.03,304.26L203.61,304.6L202.78,306.71L200.12,305.48L200.41,303.11L196.21,303.79L195.14,298.56L196.74,296.72L197.86,292.36L200,291.61L195.43,290.04L193.63,288.48L193.63,288.48L193.77,287.99L193.77,287.99L193.76,286.9L193.76,286.9L193.42,286.06L198.64,283.92L196.92,278.51L197.58,273.61L200.76,269.07L203.37,268.77L208.76,265.98L212.26,267.31L218.82,267.65L219.85,269.89L222.66,269.79L221.06,266.01L221.06,266.01L221.28,264.31L222.64,263.54L223.8,261L225.46,261.75L227.91,265.15L227.61,266.17L228.96,268.67L230.65,269.41L231.29,271.33L233.1,271.3L234.86,273.58L238.04,272.07L240.36,272.73L241.59,274.79L244.24,275.94L245.45,277.47L246.56,276.68L247.93,277.84L247.04,280.08L247.76,282.23L251.55,283.37L254.14,285.19L255.32,284.41L259.98,288.37L264.25,289.95L264.37,291.1L261.27,292.6L257.26,296.62L255.55,297.11L254.36,299.58L251.03,302.04L251.71,305.3L248.22,309.49L249.61,312.16L249.24,314.58L244.52,321.14L244.59,323.34z"
				},
				{
					"id":"IN-WB",
					"title":"West Bengal",
					"d":"M422.93,362.22l2.23,1.25l0.66,2.71l2.96,1.21l1.8,2.26l4.95,-0.82l4.55,1.53l1.11,0.68l0.01,1.08l3.08,0.2l0,0l0.12,8.55l-3.07,3.24l0,0l-0.98,-0.86l-0.81,1.7l0.83,1.9l-1.11,1.21l-4.68,-0.21l-3.79,-2.93l-1.32,-5.27l-2.55,-1.31l-0.48,1.94l2.48,1.89l-0.48,0.9l-3.35,-0.11l-2.49,-1.21l-1.13,-2.89l-5.14,-3.06l-0.35,-1.64l-1.59,3.27l0.43,0.65l0.31,-0.71l2.26,0.58l0.85,2.12l-2.6,0.96l-0.98,2.39l-3.4,1.58l-1.79,5.34l1,2.94l2.66,-0.47l3.61,3.33l0.09,1.58l2.11,1.92l4.99,-0.13l0.89,3.3l3.4,1.68l-1.55,2.84l-9.82,-0.54l0.15,2.57l-1.32,3.04l-1.2,1.6l-2.44,-1.85l-1.62,0.78l0.53,1.53l-2.52,3.67l1.78,4.01l7.73,4.22l4,0.27l1.02,2.01l-1.05,1.52l0.01,1.48l1.1,0.93l-0.41,2.74l-2.73,1.33l-0.74,4.72l3.92,3.95l0.6,-0.52l-1.52,4.04l0.3,1.42l5.25,0.91l-2.22,2.53l-0.24,2.75l1.36,2.19l1.31,12.04l2.07,3.99l-1.17,1.2l0.43,3.44l-1.08,0.63l1.62,6.12l-1.53,0.53l-3.23,-0.61l-1.52,1.62l-1.36,-0.16l-0.32,-6.16l1.42,-3.57l-1.08,-1.25l-0.59,2.83l-1.23,-0.63l1.07,-5.18l-1.3,2.18l-1.14,6.15l0.16,1.1l1.28,0.36l-1.15,4.23l-1.52,0.86l-0.3,-0.73l0.87,-2.24l-0.52,-6.42l-1.02,7.4l-0.98,0.61l-1.98,-0.59l-0.22,-3.64l-0.7,-0.45l0.89,5.04l-0.97,0.4l-1.58,-2.83l0.53,-2.51l-1.29,-3.66l1.41,-2.11l-0.27,-2.16l-3.94,-1.84l-2.08,-4.08l1.56,4.35l3.05,0.99l0.74,1.95l-6.92,8.15l-3.09,1.61l-4.06,0.75l0,0l-0.64,-3.59l-3.61,-1.44l-1.12,-1.32l0.17,-1.63l-1.61,-0.42l-1.31,2.33l-1.05,0l-0.87,-1.13l0.35,-2.79l-6.14,-2.33l-0.29,-0.83l0,0l2.98,-1.66l1.22,0.19l0.33,-0.82l-2.57,-5.82l-3.19,-2.55l0,0l-2.28,-0.72l0,0l-1.68,-1.49l0,0l0.67,-2.79l1.81,-1.45l-5.03,-0.33l0,0l-2.71,-0.45l0,0l-3.27,-3.07l-1.55,-0.05l0,0l-1.49,-0.18l-0.92,-1.87l0,0l2.26,-4.82l2.15,-2.39l1.89,-0.04l0.3,2.25l3.05,1.61l1.36,-1.37l0,0l0.48,-2.11l0,0l3.88,-2.66l0,0l2.86,-0.6l0,0l0.84,0.85l1.59,-0.36l-0.17,-2.04l0,0l-0.1,-0.8l0,0l1.88,-1.56l1.49,0.57l0,0l0.4,0.17l0,0l2.47,1.2l2.51,-0.84l0.94,-1.74l0,0l-0.65,-2.03l0,0l-0.43,-0.92l0,0l1.39,0.01l0,0l3.24,0.97l0,0l0.43,-2.49l0,0l4.1,-1.75l0,0l-0.72,-1.25l1.63,-1.43l3.09,-6.35l0,0l0.8,-1.54l-1.04,-8.26l0,0l-0.38,-0.59l0,0l-1.5,-1.45l0.04,-6.27l3.14,-3.34l0,0l1.91,0.59l0.34,-0.8l0,0l0.17,-3.4l-4.67,-4.21l0,-3.1l9.2,-7.54l-1.71,-3.95l-1.9,0.06l1.9,-5.25l-0.42,-2.66l-3.68,-5.39l0.32,-0.9l0,0l8.75,1.92l3.13,-2.38L422.93,362.22zM410.87,483.8l-0.68,2.32l-1.67,-0.34l1.62,-5.24L410.87,483.8z"
				}
			]
		}
	}
};