/* Funções da tabela Configuracoes/Funcionario */
window.onload = function () {
    var table = $('#categorias').DataTable({
      "language": {
        "sEmptyTable": "Nenhum registro encontrado",
        "sInfo": "Mostrando de _START_ até _END_ de _TOTAL_ registros",
        "sInfoEmpty": "Mostrando 0 até 0 de 0 registros",
        "sInfoFiltered": "(Filtrados de _MAX_ registros)",
        "sInfoPostFix": "",
        "sInfoThousands": ".",
        "sLengthMenu": "_MENU_ resultados por página",
        "sLoadingRecords": "Carregando...",
        "sProcessing": "Processando...",
        "sZeroRecords": "Nenhum registro encontrado",
        "sSearch": "Pesquisar",
        "oPaginate": {
          "sNext": "Próximo",
          "sPrevious": "Anterior",
          "sFirst": "Primeiro",
          "sLast": "Último"
        },
        "oAria": {
          "sSortAscending": ": Ordenar colunas de forma ascendente",
          "sSortDescending": ": Ordenar colunas de forma descendente"
        }
      },
      "pageLength": 100,
      scrollX: true
    });
  
    $('#usuarios tbody').on('click', 'tr', function () {
      $(this).toggleClass('selected');
    });
  
    $('#gravar_usuario').click(function () {
      swal({
        title: "Deseja salvar?",
        text: "Certifique-se de ter verificado todos os dados antes de efetuar a ação!",
        type: "warning",
        showCancelButton: true,
        confirmButtonColor: "#1E9FF2",
        confirmButtonText: "Sim, pode salvar!",
        cancelButtonText: "Não, cancele!",
        closeOnConfirm: true,
        closeOnCancel: false
      }, function (isConfirm) {
        if (isConfirm) {
          $('#frmUsuario_cadastro').submit();
        } else {
          swal("Cancelado", "Operação cancelada! Dados não gravados", "error");
        }
      });
    });

    $("#categorias button").click(function () {
        var classe = $(this).attr('class');
        if (classe == "btn bg-red btn-list-icon") {
          var id = $(this).attr('id');
          swal({
            title: "Deseja excluir?",
            text: "Ao excluir, o mesmo será removido permanentemente",
            type: "warning",
            showCancelButton: true,
            confirmButtonColor: "#1E9FF2",
            confirmButtonText: "Sim, pode excluir!",
            cancelButtonText: "Não, cancele!",
            closeOnConfirm: true,
            closeOnCancel: false
          }, function (isConfirm) {
            if (isConfirm) {
              window.location.replace(base_url + "Administrativo/Modalidades/modalidadesExcluir/" + id);
            } else {
              swal("Cancelado", "Operação cancelada!", "error");
            }
          });
        }
    
      });
  
    /** Limpa e gera pesquisa */
    $('#limpafrmpesquisa').click(function () {
      $("#frm_pesquisa")[0].reset();
      $('#frm_pesquisa input').val(""); //coloca todos valores de todos inputs do form como vazio
      $(":checkbox").prop('checked', false);
      $(':checkbox').find('checked').remove();
    });
    $('#enviafrmpesquisa').click(function () {
      $("#frm_pesquisa")[0].submit();
    });
  };
  