<?php namespace App\Models\Administrativo;

use CodeIgniter\Model;

class TransportesModel extends Model{

    public function __construct(){
        $this->db      = \Config\Database::connect();
        $this->builder = $this->db->table('CAD_TRANSPORTES');
        $this->session = \Config\Services::session();
        $this->usuario = $this->session->get('dadoslogin');
    }

    function getTransportes(){
        return $this->builder->get();
    }

    function getTransportesID($id){
        $this->builder->where('ID_TRANSPORTE', $id);
        //return $builder->get()->getRow();
        return $this->builder->get()->getRow();
    }

    function setTransportes($dados){
        $builder = $this->db->table('CAD_TRANSPORTES');
        $builder->insert($dados);
        $id = $this->db->insertID();
        sys_log($this->usuario['ID_USUARIO'], "Inserção de dados ID: ".$id."", "CAD_TRANSPORTES");
        return $id;
    }

    function updateTransportes($dados){
        $builder = $this->db->table('CAD_TRANSPORTES');
        $builder->where('ID_TRANSPORTE', $dados['ID_TRANSPORTE']);
        $builder->update($dados);
        sys_log($this->usuario['ID_USUARIO'], "Atualização de dados ID: ".$dados['ID_TRANSPORTE']."", "CAD_TRANSPORTES");
        return $this->db->affectedRows();
    }

    function modelidadesDeletar($idcategoria){   
        $this->builder->where('ID_TRANSPORTE', $idcategoria);
        $this->builder->where('ID_TRANSPORTE', $idcategoria)->delete();  
        
    }

    
}
?>