<?php namespace App\Models\Configuracoes;

use CodeIgniter\Model;

class AgendaModel extends Model{

    protected $table = 'CON_AGENDA';
    protected $primaryKey = 'ID_AGENDA';
    protected $allowedFields = ['TITULO, DESCRICAO, INICIO, FIM, COR'];

    public function __construct(){
        $this->db      = \Config\Database::connect();
        $this->builder = $this->db->table('CON_AGENDA');
    }

    function agendaMensal($usuario){
        $this->builder->where('FK_ID_USUARIO',$usuario);
        return $this->builder->get()->getResultArray();
    }

    function getEventUnico($id){
        $this->builder->select('CON_AGENDA.*, DATE_FORMAT(INICIO, \'%d/%m/%Y %H:%i\') as datainicio,DATE_FORMAT(FIM, \'%d/%m/%Y %H:%i\') as datafim');
        $this->builder->where('ID_AGENDA',$id);
        return $this->builder->get()->getResultArray();
    }

    function setLembrete($dados){
        $this->builder->insert($dados);
        $id = $this->db->insertID();
        sys_log($this->usuario['ID_USUARIO'], "Inserção de dados ID: ".$id."", "CON_AGENDA");
        return $id;
    }

    function deleteLembrete($id){
        $this->builder->where('ID_AGENDA', $id)->delete();
        sys_log($this->usuario['ID_USUARIO'], "Exclusão de EVENTO: ".$id."", "CON_AGENDA");
        return $this->db->affectedRows();
    }
}
?>