/* Funções da tabela Configuracoes/Funcionario */
window.onload = function () {
  var base_url = window.location.origin + "/";
  var table = $('#contatos').DataTable({
    "language": {
      "sEmptyTable": "Nenhum registro encontrado",
      "sInfo": "Mostrando de _START_ até _END_ de _TOTAL_ registros",
      "sInfoEmpty": "Mostrando 0 até 0 de 0 registros",
      "sInfoFiltered": "(Filtrados de _MAX_ registros)",
      "sInfoPostFix": "",
      "sInfoThousands": ".",
      "sLengthMenu": "_MENU_ resultados por página",
      "sLoadingRecords": "Carregando...",
      "sProcessing": "Processando...",
      "sZeroRecords": "Nenhum registro encontrado",
      "sSearch": "Pesquisar",
      "oPaginate": {
        "sNext": "Próximo",
        "sPrevious": "Anterior",
        "sFirst": "Primeiro",
        "sLast": "Último"
      },
      "oAria": {
        "sSortAscending": ": Ordenar colunas de forma ascendente",
        "sSortDescending": ": Ordenar colunas de forma descendente"
      },
      "select": {
        "rows": {
          "_": "Selecionado %d cliente",
          "0": "Nenhum cliente selecionado",
          "1": "Selecionado 1 cliente"
        }
      },
    },
    select: true,
    pageLength: 1000,
    dom: 'Bfrtip',
    buttons: [{
        text: 'Marcar todos',
        action: function () {
          table.rows().select();
        }
      },
      {
        text: 'Desmarcar todos',
        action: function () {
          table.rows().deselect();
        }
      }
    ],
    scrollX: true
  });

  $('#contatos tbody').on('click', 'tr', function () {
    $(this).toggleClass('selected');
  });

  $('#enviafrmpesquisa').click(function () {
    $("#frm_pesquisa_tipo_parceiro")[0].submit();
  });

  // Replace the <textarea id="parametro_layout"> with a CKEditor
  // instance, using default configuration.
  CKEDITOR.replace('envio_email')
  //bootstrap WYSIHTML5 - text editor
  $('.textarea').wysihtml5();

  $('#msg_sms').hide();
  $('#msg_email').hide();
  $('#btn_enviar').hide();

  $('#tipo_servico').change(function () {
    var servico = $(this).val();
    if (servico == "sms") {
      $('#msg_email').hide();
      $('#msg_sms').show();
      $('#btn_enviar').show();
    } else if (servico == "email") {
      $('#msg_sms').hide();
      $('#msg_email').show();
      $('#btn_enviar').show();
    }
  });

  $('#enviar').click(function () {
    swal({
      title: "Deseja enviar?",
      text: "Certifique-se de ter selecionado os contatos corretos antes de efetuar a ação!",
      type: "warning",
      showCancelButton: true,
      confirmButtonColor: "#1E9FF2",
      confirmButtonText: "Sim, pode enviar!",
      cancelButtonText: "Não, cancele!",
      closeOnConfirm: false,
      closeOnCancel: false
    }, function (isConfirm) {
      if (isConfirm) {
        var servico = $('#tipo_servico').val();
        var msg_sms = $('#envio_sms').val();
        var msg_email = CKEDITOR.instances["envio_email"].getData();
        var email = [];
        var sms = [];
        var x = 0;
        $('#contatos tr.selected').each(function () {
          email[x] = $(this).find('.email').html();
          sms[x] = new Object();
          sms[x]['telefone'] = $(this).find('.sms').html();
          sms[x]['contatos'] = $(this).find('.contatos').html();
          x++;
        });
        if (sms == null || sms == "") {
          window.setTimeout(function () {
            swal("Erro", "Nenhum cliente selecionado", "error");
          }, 1000);
        } else {
          $.ajax({
            type: "POST",
            url: base_url + 'Rotinas/Envios/dispararEmailSms',
            data: {
              'email': email,
              'sms': sms,
              'servico': servico,
              'msg_sms': msg_sms,
              'msg_email': msg_email
            },
            dataType: 'json',
            success: function (data) {
              if (data.msg == "sucesso") {
                swal({
                  title: "Sucesso",
                  type: "success",
                  confirmButtonText: "Ok",
                  text: "Status alterado!",
                }, function () {
                  location.reload();
                });
              } else {
                swal("Erro", "Nenhum disparo efetuado", "error");
              }
            }
          });
        }
      } else {
        swal("Cancelado", "Operação cancelada! Dados não enviados", "error");
      }
    });
  });
};
