<?php namespace App\Controllers\Administrativo;

 use App\Models\Administrativo\ModalidadesModel;
 use CodeIgniter\Controller;
 use App\Libraries\Auth;
 
 class Modalidades extends Controller
 {

	public function __construct(){
        $this->session = \Config\Services::session();
        $this->usuario = $this->session->get('dadoslogin');
        if($this->usuario == null){
            header('Location: '.base_url());
            exit(); 
        }
        $this->modalidadesModel = new ModalidadesModel();
        $this->auth = new Auth();
        helper('complementos'); 
	}

	public function modalidadesConsultar(){
        if($this->auth->CheckAuth(17)){
        $dados['resultados'] = $this->modalidadesModel->getModalidades();
        echo view('Commons/header');	
        echo view('Commons/navbartop');
        echo view('Commons/navbarleft', getBarMenu($this->usuario));
        echo view('Administrativo/Modalidades/modalidades', $dados);
        echo view('Commons/footer');
        }else{
            return redirect()->to('/Acesso');
        }
	}

    public function modalidadesEditar($id=""){
        if($this->auth->CheckAuth(19)){
            $dados['modalidade'] = $this->modalidadesModel->getModalidadesID(base64_decode($id));
            echo view('Commons/header');
            echo view('Commons/navbartop');
            echo view('Commons/navbarleft', getBarMenu($this->usuario));
            echo view('Administrativo/Modalidades/cad_modalidades', $dados);
            echo view('Commons/footer');
        }else{
            return redirect()->to('/Acesso');
        }
    }
    
            public function modalidadesExcluir($id=""){
                if($this->auth->CheckAuth(20)){
                $this->modalidadesModel->modelidadesDeletar(base64_decode($id));
                return redirect()->to('/Administrativo/Modalidades/modalidadesConsultar?tipo_msg=sucesso&msg=Ação realizada!');
                                                }else{
                                                    return redirect()->to('/Acesso');
                                                }
            }
        
            public function modalidadesInserir(){
                if($this->auth->CheckAuth(18)){
                $dados = array();
                $id = $this->request->getPost('id_modalidade');
                if($id == ""){
                    $dados['NOME_MODALIDADE'] = $this->request->getPost('nome_modalidade');
                   /* $dados['USUARIO'] = $this->request->getPost('usuario_login');
                    $dados['SENHA'] = sha1(preg_replace('/[^[:alnum:]_]/', '',$this->request->getPost('usuario_senha'))); 
                    $dados['EMAIL'] = $this->request->getPost('usuario_email');
                    $dados['TELEFONE'] = $this->request->getPost('usuario_telefone');
                    $dados['ATIVO'] = $this->request->getPost('usuario_status');*/
                    
                    if($this->modalidadesModel->setModalidades($dados)){
                       
                        return redirect()->to('/Administrativo/Modalidades/modalidadesConsultar?tipo_msg=sucesso&msg=Ação realizada!');
                    }else{
                        return redirect()->to('/Administrativo/Modalidades/modalidadesConsultar?tipo_msg=erro&msg=Erro ao realizar ação!');
                    }
                }else{
                    $dados['ID_MODALIDADE'] = $this->request->getPost('id_modalidade');
                    $dados['NOME_MODALIDADE'] = $this->request->getPost('nome_modalidade');
                    
                   /* $dados['NOME'] = $this->request->getPost('usuario_nome');
                    $dados['USUARIO'] = $this->request->getPost('usuario_login');
                    $dados['EMAIL'] = $this->request->getPost('usuario_email');
                    $dados['TELEFONE'] = $this->request->getPost('usuario_telefone');
                    $dados['ATIVO'] = $this->request->getPost('usuario_status');*/
        
                    
                    
                    if($this->modalidadesModel->updateModalidades($dados)){
                       
                        return redirect()->to('/Administrativo/Modalidades/modalidadesConsultar?tipo_msg=sucesso&msg=Ação realizada!');
                    }else{
                        return redirect()->to('/Administrativo/Modalidades/modalidadesConsultar?tipo_msg=erro&msg=Erro ao realizar ação!');
                    }
                }
                    }else{
                        return redirect()->to('/Acesso');
                    }
            }

        
        
        
        
}
