<?php namespace App\Models\Administrativo;

use CodeIgniter\Model;

class ContratosModel extends Model{

    public function __construct(){
        $this->db      = \Config\Database::connect();
        $this->builder = $this->db->table('CAD_CONTRATOS');
        $this->session = \Config\Services::session();
        $this->usuario = $this->session->get('dadoslogin');
    }

    function getContratos(){
        return $this->builder->get();
    }

    function getContratosID($id){
        $this->builder->where('ID_CONTRATO', $id);
        //return $builder->get()->getRow();
        return $this->builder->get()->getRow();
    }

    function setContratos($dados){
        $builder = $this->db->table('CAD_CONTRATOS');
        $builder->insert($dados);
        $id = $this->db->insertID();
        sys_log($this->usuario['ID_USUARIO'], "Inserção de dados ID: ".$id."", "CAD_CONTRATOS");
        return $id;
    }

    function updateContratos($dados){
        $builder = $this->db->table('CAD_CONTRATOS');
        $builder->where('ID_CONTRATO', $dados['ID_CONTRATO']);
        $builder->update($dados);
        sys_log($this->usuario['ID_USUARIO'], "Atualização de dados ID: ".$dados['ID_CONTRATO']."", "CAD_CONTRATOS");
        return $this->db->affectedRows();
    }

    function deletarContratos($idpessoas){   
        $this->builder->where('ID_CONTRATO', $idpessoas);
        $resultado = $this->builder->get()->getRow();
        $this->builder->where('ID_CONTRATO', $idpessoas)->delete();  
    
        
    }
    function pessoasVerificar($idenditidade){
        $builder = $this->db->table('CAD_CONTRATOS');
        $builder->select('ID_CONTRATO');
        $builder->where('DOCUMENTO_CONTRATO', $idenditidade);
        return $builder->get()->getResultArray();
        
    }

    function contratosImprimir($id){
        $builder = $this->db->table('CAD_CONTRATOS AS A');
        $builder->select('A.ID_CONTRATO, P.NOME_PESSOA AS COMPRADOR, P.ENDERECO_PESSOA AS COMPRADOR_ENDERECO, P.BAIRRO_PESSOA AS COMPRADOR_BAIRRO,
         P.CIDADE_PESSOA AS COMPRADOR_CIDADE, P.CEP_PESSOA AS COMPRADOR_CEP, 
         P.ESTADO_PESSOA AS COMPRADOR_ESTADO, P.DOCUMENTO_PESSOA AS COMPRADOR_DOCUMENTO,
         P.IE_PESSOA AS COMPRADOR_IE, 
         P.TIPO_PESSOA AS COMPRADOR_TIPO, A.CORRETOR_CONTRATO, V.NOME_PESSOA AS VENDEDOR,
         AET.NOME_ARMAZEM AS ARMARZEMET , 
          MOD.NOME_MODALIDADE AS MODALIDADE, TRA.NOME_TRANSPORTE AS TRANSPORTE,
           A.TAMANHO_SACA, A.QUANTIDADE_SACA, 
           A.PRECO_SACA, A.VALOR_TOTAL_SACA, A.CORRETAGEM_VENDEDOR, A.VALOR_CVENDEDOR,
            A.CORRETAGEM_COMPRADOR, A.VALOR_CCOMPRADOR, A.CONDICAO_PAGAMENTO,
             A.DESCRICAO_CONTRATO, V.ENDERECO_PESSOA AS VENDEDOR_ENDERECO,
             V.BAIRRO_PESSOA AS VENDEDOR_BAIRRO, V.CIDADE_PESSOA AS VENDEDOR_CIDADE,
             V.CEP_PESSOA AS VENDEDOR_CEP, V.ESTADO_PESSOA AS VENDEDOR_ESTADO,
             V.DOCUMENTO_PESSOA AS VENDEDOR_DOCUMENTO, V.TIPO_PESSOA AS VENDEDOR_TIPO,
             V.IE_PESSOA AS VENDEDOR_IE, 
             ART.NOME_ARMAZEM AS NOME_ARMAZEMRT, ART.ENDERECO_ARMAZEM AS ARMAZEMRT_ENDERECO,
              ART.BAIRRO_ARMAZEM AS ARMAZEMRT_BAIRRO, ART.CIDADE_ARMAZEM AS ARMAZEMRT_CIDADE,
               ART.CEP_ARMAZEM AS ARMAZEMRT_CEP, ART.ESTADO_ARMAZEM AS ARMAZEMRT_ESTADO, 
               ART.DOCUMENTO_ARMAZEM AS ARMAZEMRT_DOCUMENTO, ART.IE_ARMAZEM AS ARMAZEMRT_IE,
              AET.NOME_ARMAZEM AS NOME_ARMAZEMET, AET.ENDERECO_ARMAZEM AS ARMAZEMET_ENDERECO, 
              AET.BAIRRO_ARMAZEM AS ARMAZEMET_BAIRRO,  
            AET.CIDADE_ARMAZEM AS ARMAZEMET_CIDADE, AET.CEP_ARMAZEM AS ARMAZEMET_CEP,  
            AET.ESTADO_ARMAZEM AS ARMAZEMET_ESTADO, AET.DOCUMENTO_ARMAZEM AS ARMAZEMET_DOCUMENTO, AET.IE_ARMAZEM AS ARMAZEMET_IE,
            A.BANCO, A.AGENCIA, A.CONTA, A.CIDADE_BANCO, A.OBS_CONTRATO, A.DATA_CONTRATO,
            A.NUM_COMPRADOR,
             
             
             
             
             
             ');
        $builder->join('CAD_PESSOAS AS P', 'A.FK_ID_COMPRADOR = P.ID_PESSOA', 'LEFT');
        $builder->join('CAD_PESSOAS AS V', 'A.FK_ID_VENDEDOR = V.ID_PESSOA', 'LEFT');
        $builder->join('CAD_ARMAZENS AS ART', 'A.FK_ID_ARMAZEM_RT = ART.ID_ARMAZEM', 'LEFT');
        $builder->join('CAD_ARMAZENS AS AET', 'A.FK_ID_ARMAZEM_ET = AET.ID_ARMAZEM', 'LEFT');
        $builder->join('CAD_MODALIDADES AS MOD', 'A.FK_ID_MODALIDADE = MOD.ID_MODALIDADE', 'LEFT');
        $builder->join('CAD_TRANSPORTES AS TRA', 'A.FK_ID_TRANSPORTE = TRA.ID_TRANSPORTE', 'LEFT');
        $builder->where('A.ID_CONTRATO', $id);
        return $builder->get()->getRow();;
        
    }
    
}
?>