/* Funções da tabela Configuracoes/Funcionario */
window.onload = function () {
  tipo();
  $('#cadarmazens tbody').on('click', 'tr', function () {
    $(this).toggleClass('selected');
  });

  $('#gravar_armazem').click(function () {
    swal({
      title: "Deseja salvar?",
      text: "Certifique-se de ter verificado todos os dados antes de efetuar a ação!",
      type: "warning",
      showCancelButton: true,
      confirmButtonColor: "#1E9FF2",
      confirmButtonText: "Sim, pode salvar!",
      cancelButtonText: "Não, cancele!",
      closeOnConfirm: true,
      closeOnCancel: false
    }, function (isConfirm) {
      if (isConfirm) {
        $('#cadarmazens').submit();
        
        
        
      } else {
        swal("Cancelado", "Operação cancelada! Dados não gravados", "error");
      }
    });
  });

  $('#documento_armazem').blur(function () {
    var documento = document.getElementById('documento_armazem').value.replace(/[^\d]+/g,'');
    
    //var usuario = $(this).val();
    $.ajax({
      type: "POST",
      url: base_url + 'Administrativo/Armazens/armazensVerificar',
      data: {
        'documento': documento,
        csrf_token: $('#crsf_token').val()
      },
      dataType: 'json',
      success: function (data) {
        
        if (data.length > 0) {
          if (documento != "") {
            var idpessoa= document.getElementById('id_armazem').value;
            if (idpessoa ==""){
            if (documento != data[0].DOCUMENTO_PESSOA) {
              swal({
                title: "Usuário encontrado!",
                text: "O usuário informado já existe na base de dados, deseja editá-lo?",
                type: "warning",
                showCancelButton: true,
                confirmButtonColor: "#1E9FF2",
                confirmButtonText: "Sim, desejo editar!",
                cancelButtonText: "Não, cancele!",
                closeOnConfirm: true,
                closeOnCancel: false
              }, function (isConfirm) {
                if (isConfirm) {
                  
                  window.location.replace(base_url + "Administrativo/Armazens/armazensEditar/" +btoa(data[0].ID_ARMAZEM));


                } else {
                  swal("Cancelado", "Operação cancelada!", "error");
                 
                
                  $('#documento_armazem').val("");
                 
                }
              });
            }

          }
          } else {
            swal({
              title: "Usuário encontrado!",
              text: "O usuário informado já existe na base de dados, deseja editá-lo?",
              type: "warning",
              showCancelButton: true,
              confirmButtonColor: "#1E9FF2",
              confirmButtonText: "Sim, desejo editar!",
              cancelButtonText: "Não, cancele!",
              closeOnConfirm: true,
              closeOnCancel: false
            }, function (isConfirm) {
              if (isConfirm) {
                
                window.location.replace(base_url + "/Administrativo/Armazens/armazensEditar/" + btoa(data[0].ID_ARMAZEM));
              } else {
                swal("Cancelado", "Operação cancelada!", "error");
                $('#documento_armazem').val("");
              }
            });
          }
        }
      }
    });
  });

  /** Limpa e gera pesquisa */
  $('#limpafrmpesquisa').click(function () {
    $("#frm_pesquisa")[0].reset();
    $('#frm_pesquisa input').val(""); //coloca todos valores de todos inputs do form como vazio
    $(":checkbox").prop('checked', false);
    $(':checkbox').find('checked').remove();
  });
  $('#enviafrmpesquisa').click(function () {
    $("#frm_pesquisa")[0].submit();
  });  
 

};




function mascara(inputmask){
  var t = document.querySelector("#telefone_pessoa");
  var i = t.value.length;
  var saida = inputmask.substring(1,0);
  var texto = inputmask.substring(i)
  if (texto.substring(0,1) != saida){
  t.value += texto.substring(0,1);
  }
}


function tipo(){

  //$("#documento_pessoa").inputmask("999.999.999-99")
			$("#documento_armazem").inputmask("99.999.999/9999-99")
      $("#telefone_armazem").inputmask("(99) 99999-9999")
			$("#salario").inputmask("999.999.990,00", {reverse: true})
		$("#cep_armazem").inputmask("99.999-999")
      $("#cep_empresa").inputmask("99.999-999")
			$("#dataNascimento").inputmask("00/00/0000")
			
			$("#rg").inputmask("999.999.999-W", {
				translation: {
					'W': {
						pattern: /[X0-9]/
					}
				},
				reverse: true
			})
			
			var options = {
				translation: {
					'A': {pattern: /[A-Z]/},
					'a': {pattern: /[a-zA-Z]/},
					'S': {pattern: /[a-zA-Z0-9]/},
					'L': {pattern: /[a-z]/},
				}
			}
			
			$("#placa").inputmask("AAA-0000", options)
			
			$("#codigo").inputmask("AA.LLL.0000", options)
			
			$("#celular").inputmask("(00) 0000-00009")
			
			$("#celular").blur(function(event){
				if ($(this).val().length == 15){
					$("#celular").inputmask("(00) 00000-0009")
				}else{
					$("#celular").inputmask("(00) 0000-00009")
				}
			})





      
  }

  function limpa_formulário_cep() {
    //Limpa valores do formulário de cep.
    
    document.getElementById('endereco_armazem').value=("");
    document.getElementById('bairro_armazem').value=("");
    document.getElementById('cidade_armazem').value=("");
    document.getElementById('estado_armazem').value=("");

   // document.getElementById('uf').value=("");
    //document.getElementById('ibge').value=("");
}

function meu_callback(conteudo) {
if (!("erro" in conteudo)) {
    //Atualiza os campos com os valores.
    
      document.getElementById('endereco_armazem').value=(conteudo.logradouro);
    
    
    document.getElementById('bairro_armazem').value=(conteudo.bairro);
    document.getElementById('cidade_armazem').value=(conteudo.localidade);
    document.getElementById('estado_armazem').value=(conteudo.uf);

   // document.getElementById('ibge').value=(conteudo.ibge);
} //end if.
else {
    //CEP não Encontrado.
    limpa_formulário_cep();
    alert("CEP não encontrado.");
}
}

function pesquisacep(valor) {

//Nova variável "cep" somente com dígitos.
var cep = valor.replace(/\D/g, '');

//Verifica se campo cep possui valor informado.
if (cep != "") {

    //Expressão regular para validar o CEP.
    var validacep = /^[0-9]{8}$/;

    //Valida o formato do CEP.
    if(validacep.test(cep)) {

        //Preenche os campos com "..." enquanto consulta webservice.
        document.getElementById('endereco_armazem').value="...";
        document.getElementById('bairro_armazem').value="...";
        document.getElementById('cidade_armazem').value="...";
        document.getElementById('estado_armazem').value="...";
 
        //document.getElementById('ibge').value="...";

        //Cria um elemento javascript.
        var script = document.createElement('script');

        //Sincroniza com o callback.
        script.src = 'https://viacep.com.br/ws/'+ cep + '/json/?callback=meu_callback';

        //Insere script no documento e carrega o conteúdo.
        document.body.appendChild(script);

    } //end if.
    else {
        //cep é inválido.
        limpa_formulário_cep();
        alert("Formato de CEP inválido.");
    }
} //end if.
else {
    //cep sem valor, limpa formulário.
    limpa_formulário_cep();
}
};

 


