<?php namespace App\Controllers\Administrativo;

 use App\Models\Administrativo\ProdutoModel;
 use App\Models\Administrativo\CategoriaModel;
 use CodeIgniter\Controller;
 use App\Libraries\Auth;
 
 class Produtos extends Controller
 {

        public function __construct(){
            $this->session = \Config\Services::session();
            $this->usuario = $this->session->get('dadoslogin');
            if($this->usuario == null){
                header('Location: '.base_url());
                exit(); 
            }
            //$this->load->helper(array('form', 'url'));
            $this->produtoModel = new ProdutoModel();
            $this->categoriaModel = new CategoriaModel();
            $this->auth = new Auth();
            helper('complementos'); 
        }

	public function produtosConsultar(){
        if($this->auth->CheckAuth(13)){
            $dados['resultados'] = $this->produtoModel->getProduto();
            $dados['categorias'] = $this->categoriaModel->getCategoria();
            echo view('Commons/header');	
            echo view('Commons/navbartop');
            echo view('Commons/navbarleft', getBarMenu($this->usuario));
            echo view('Administrativo/Produto/produto', $dados);
            echo view('Commons/footer');
        }else{
            return redirect()->to('/Acesso');
        }
	}

        public function produtosEditar($id=""){
            if($this->auth->CheckAuth(15)){
                $dados['produto'] = $this->produtoModel->getProdutoID(base64_decode($id));
                $dados['categorias'] = $this->categoriaModel->getCategoria();
                echo view('Commons/header');
                echo view('Commons/navbartop');
                echo view('Commons/navbarleft', getBarMenu($this->usuario));
                echo view('Administrativo/Produto/cad_produto', $dados);
                echo view('Commons/footer');
            }else{
                return redirect()->to('/Acesso');
            }
        }
            
        public function produtosExcluir($id=""){
            if($this->auth->CheckAuth(22)){
                $this->produtoModel->produtoDeletar(base64_decode($id));
                return redirect()->to('/Administrativo/Produtos/produtosConsultar?tipo_msg=sucesso&msg=Ação realizada!');
            }
        }
        
        
        public function produtosInserir(){
            if($this->auth->CheckAuth(14)){
                $dados = array();
                $id = $this->request->getPost('id_produto');
                if($id == ""){
                    $dados['NOME_PRODUTO'] = $this->request->getPost('nome_produto');
                    $dados['DESC_PRODUTO'] = $this->request->getPost('desc_produto');
                    $dados['VALOR_PRODUTO'] = $this->request->getPost('valor_produto');
                    $dados['FK_ID_CATEGORIA'] = $this->request->getPost('fk_id_categoria');
                    $dados['UN_MEDIDA'] = $this->request->getPost('un_medida');
                    $dados['CAMINHO_IMAGEM'] = $this->caminhoimage();
                   /* $dados['USUARIO'] = $this->request->getPost('usuario_login');
                    $dados['SENHA'] = sha1(preg_replace('/[^[:alnum:]_]/', '',$this->request->getPost('usuario_senha'))); 
                    $dados['EMAIL'] = $this->request->getPost('usuario_email');
                    $dados['TELEFONE'] = $this->request->getPost('usuario_telefone');
                    $dados['ATIVO'] = $this->request->getPost('usuario_status');*/
                    
                    if($this->produtoModel->setProduto($dados)){
                        $this->salvarimage();
                        return redirect()->to('/Administrativo/Produtos/produtosConsultar?tipo_msg=sucesso&msg=Ação realizada!');
                        
                    }else{
                        return redirect()->to('/Administrativo/Produtos/produtosConsultar?tipo_msg=erro&msg=Erro ao realizar ação!');
                    }
                }else{
                    $dados['ID_PRODUTO'] = $this->request->getPost('id_produto');
                    $dados['NOME_PRODUTO'] = $this->request->getPost('nome_produto');
                    $dados['DESC_PRODUTO'] = $this->request->getPost('desc_produto');
                    $dados['VALOR_PRODUTO'] = $this->request->getPost('valor_produto');
                    $dados['FK_ID_CATEGORIA'] = $this->request->getPost('fk_id_categoria');
                    $dados['UN_MEDIDA'] = $this->request->getPost('un_medida');
                    $img = $this->request->getFile('images');
                    if ($img != ""){
                    $dados['CAMINHO_IMAGEM'] = $this->caminhoimage();
                    }
                   /* $dados['NOME'] = $this->request->getPost('usuario_nome');
                    $dados['USUARIO'] = $this->request->getPost('usuario_login');
                    $dados['EMAIL'] = $this->request->getPost('usuario_email');
                    $dados['TELEFONE'] = $this->request->getPost('usuario_telefone');
                    $dados['ATIVO'] = $this->request->getPost('usuario_status');*/
        
                    
                    
                    if($this->produtoModel->updateProduto($dados)){
                        $this->salvarimage();
                        return redirect()->to('/Administrativo/Produtos/produtosConsultar?tipo_msg=sucesso&msg=Ação realizada!');
                        
                    }else{
                        return redirect()->to('/Administrativo/Produtos/produtosConsultar?tipo_msg=erro&msg=Erro ao realizar ação!');
                    }
                }
            }else{
                return redirect()->to('/Acesso');
            }
        }


       

        public function salvarimage()
        {
            $img = $this->request->getFile('images');
           if ($img!=""){
            $img->move('./images');
           }
        
        }

        public function caminhoimage()
        {
            $img = $this->request->getFile('images');
            $caminho = '/images/'. $img->GetName();
            return $caminho;
        }








}