<?php namespace App\Models\Administrativo;

use CodeIgniter\Model;

class ArmazensModel extends Model{

    public function __construct(){
        $this->db      = \Config\Database::connect();
        $this->builder = $this->db->table('CAD_ARMAZENS');
        $this->session = \Config\Services::session();
        $this->usuario = $this->session->get('dadoslogin');
    }

    function getArmazens(){
        return $this->builder->get();
    }

    function getArmazensID($id){
        $this->builder->where('ID_ARMAZEM', $id);
        //return $builder->get()->getRow();
        return $this->builder->get()->getRow();
    }

    function setArmazens($dados){
        $builder = $this->db->table('CAD_ARMAZENS');
        $builder->insert($dados);
        $id = $this->db->insertID();
        sys_log($this->usuario['ID_USUARIO'], "Inserção de dados ID: ".$id."", "CAD_ARMAZENS");
        return $id;
    }

    function updateArmazens($dados){
        $builder = $this->db->table('CAD_ARMAZENS');
        $builder->where('ID_ARMAZEM', $dados['ID_ARMAZEM']);
        $builder->update($dados);
        sys_log($this->usuario['ID_USUARIO'], "Atualização de dados ID: ".$dados['ID_ARMAZEM']."", "CAD_ARMAZENS");
        return $this->db->affectedRows();
    }

    function deletarArmazens($idpessoas){   
        $this->builder->where('ID_ARMAZEM', $idpessoas);
        $resultado = $this->builder->get()->getRow();
        $this->builder->where('ID_ARMAZEM', $idpessoas)->delete();  
    
        
    }
    function armazensVerificar($idenditidade){
        $builder = $this->db->table('CAD_ARMAZENS');
        $builder->select('ID_ARMAZEM');
        $builder->where('DOCUMENTO_ARMAZEM', $idenditidade);
        return $builder->get()->getResultArray();
        
    }
    
}
?>