<?php namespace App\Models\Administrativo;

use CodeIgniter\Model;

class CategoriaModel extends Model{

    public function __construct(){
        $this->db      = \Config\Database::connect();
        $this->builder = $this->db->table('CAD_CATEGORIA');
        $this->session = \Config\Services::session();
        $this->usuario = $this->session->get('dadoslogin');
    }

    function getCategoria(){
        return $this->builder->get();
    }

    function getCategoriaID($id){
        $this->builder->where('ID_CATEGORIA', $id);
        //return $builder->get()->getRow();
        return $this->builder->get()->getRow();
    }

    function setCategoria($dados){
        $builder = $this->db->table('CAD_CATEGORIA');
        $builder->insert($dados);
        $id = $this->db->insertID();
        sys_log($this->usuario['ID_USUARIO'], "Inserção de dados ID: ".$id."", "CAD_CATEGORIA");
        return $id;
    }

    function updateCategoria($dados){
        $builder = $this->db->table('CAD_CATEGORIA');
        $builder->where('ID_CATEGORIA', $dados['ID_CATEGORIA']);
        $builder->update($dados);
        sys_log($this->usuario['ID_USUARIO'], "Atualização de dados ID: ".$dados['ID_CATEGORIA']."", "CAD_CATEGORIA");
        return $this->db->affectedRows();
    }

    function categoriaDeletar($idcategoria){   
        $this->builder->where('ID_CATEGORIA', $idcategoria);
        $resultado = $this->builder->get()->getRow();
        $caminho = $resultado->CAMINHO_IMAGEM;
        $this->builder->where('ID_CATEGORIA', $idcategoria)->delete();  
        $path_to_file = '.'.$caminho;
        if ($caminho!="/images/"){
            if(unlink($path_to_file)) {
                echo 'deleted successfully';
            } 
        }
        
    }

    
}
?>