<?php namespace App\Models\Administrativo;

use CodeIgniter\Model;

class ModalidadesModel extends Model{

    public function __construct(){
        $this->db      = \Config\Database::connect();
        $this->builder = $this->db->table('CAD_MODALIDADES');
        $this->session = \Config\Services::session();
        $this->usuario = $this->session->get('dadoslogin');
    }

    function getModalidades(){
        return $this->builder->get();
    }

    function getModalidadesID($id){
        $this->builder->where('ID_MODALIDADE', $id);
        //return $builder->get()->getRow();
        return $this->builder->get()->getRow();
    }

    function setModalidades($dados){
        $builder = $this->db->table('CAD_MODALIDADES');
        $builder->insert($dados);
        $id = $this->db->insertID();
        sys_log($this->usuario['ID_USUARIO'], "Inserção de dados ID: ".$id."", "CAD_MODALIDADES");
        return $id;
    }

    function updateModalidades($dados){
        $builder = $this->db->table('CAD_MODALIDADES');
        $builder->where('ID_MODALIDADE', $dados['ID_MODALIDADE']);
        $builder->update($dados);
        sys_log($this->usuario['ID_USUARIO'], "Atualização de dados ID: ".$dados['ID_MODALIDADE']."", "CAD_MODALIDADES");
        return $this->db->affectedRows();
    }

    function modelidadesDeletar($idcategoria){   
        $this->builder->where('ID_MODALIDADE', $idcategoria);
        $this->builder->where('ID_MODALIDADE', $idcategoria)->delete();  
        
    }

    
}
?>