/* Funções da tabela Configuracoes/Funcionario */
window.onload = function () {
  /** GRAVAÇÃO E VALIDAÇÃO LEMBRETE **/

  var base_url = window.location.origin + "/";


  $(".datahora").inputmask("99/99/9999 99:99");



  $('#grava_lembrete').click(function () {


    $('#formulario_lembrete').validate({

      rules: {
        txttitulolembrete: {
          minlength: 5,
          maxlength: 45,
          required: true
        },
        txtdescricaolembrete: {
          minlength: 5,
          maxlength: 200,
          required: true
        },
        txtdatainiciolembrete: {
          required: true
        },
        txtdatafinallembrete: {
          required: true
        },
      },
      highlight: function (element) {
        $(element).closest('.form-group').addClass('has-error');
      },
      unhighlight: function (element) {
        $(element).closest('.form-group').removeClass('has-error');
      },
      errorElement: 'span',
      errorClass: 'help-block',
      errorPlacement: function (error, element) {
        if (element.parent('.input-group').length) {
          error.insertAfter(element.parent());
        } else {
          error.insertAfter(element);
        }
      },
      messages: {
        txttitulolembrete: {
          minlength: 'O campo título deve ser válido',
          maxlength: 'O campo título deve ter no máximo 45 caracteres',
          required: 'O campo título é obrigatório'
        },
        txtdescricaolembrete: {
          minlength: 'O campo descrição deve ser válido',
          maxlength: 'O campo descrição deve ter no máximo 200 caracteres',
          required: 'O campo descrição é obrigatório'
        },
        txtdatainiciolembrete: {
          required: 'O campo é obrigatório'
        },
        txtdatafinallembrete: {
          required: 'O campo é obrigatório'
        }
      },
    });

    if ($('#formulario_lembrete').valid()) {
      var id_agenda = $('#id_agenda').val();
      var titulo = $('#titulo').val();
      var descricao = document.getElementById("descricao").value;
      var data_inicio = document.getElementById("data_inicio").value;
      var data_final = document.getElementById("data_final").value;
      var cor = document.getElementById("cor").value;
      var csrf_token = document.getElementById("crsf_token").value;

      $.ajax({
        type: "POST",
        url: base_url + "Configuracoes/Agenda/inserirLembrete",
        data: {
          'id_agenda': id_agenda,
          'titulo': titulo,
          'descricao': descricao,
          'data_inicio': data_inicio,
          'data_final': data_final,
          'cor': cor,
          csrf_token: csrf_token

        }

      });

      $('#modal-lembrete').modal('hide');

      bootbox.confirm({
        title: "Sucesso",
        message: "Lembrete salvo!",

        callback: function (result) {
          if (result) {
            window.location.reload();
          }
        }
      });


    }
  });

};
