/* Funções da tabela Configuracoes/Funcionario */
window.onload = function () {
  var table = $('#usuarios').DataTable({
    "language": {
      "sEmptyTable": "Nenhum registro encontrado",
      "sInfo": "Mostrando de _START_ até _END_ de _TOTAL_ registros",
      "sInfoEmpty": "Mostrando 0 até 0 de 0 registros",
      "sInfoFiltered": "(Filtrados de _MAX_ registros)",
      "sInfoPostFix": "",
      "sInfoThousands": ".",
      "sLengthMenu": "_MENU_ resultados por página",
      "sLoadingRecords": "Carregando...",
      "sProcessing": "Processando...",
      "sZeroRecords": "Nenhum registro encontrado",
      "sSearch": "Pesquisar",
      "oPaginate": {
        "sNext": "Próximo",
        "sPrevious": "Anterior",
        "sFirst": "Primeiro",
        "sLast": "Último"
      },
      "oAria": {
        "sSortAscending": ": Ordenar colunas de forma ascendente",
        "sSortDescending": ": Ordenar colunas de forma descendente"
      }
    },
    "pageLength": 100,
    scrollX: true
  });

  $('#usuarios tbody').on('click', 'tr', function () {
    $(this).toggleClass('selected');
  });

  $('#gravar_empresa').click(function () {
    swal({
      title: "Deseja salvar?",
      text: "Certifique-se de ter verificado todos os dados antes de efetuar a ação!",
      type: "warning",
      showCancelButton: true,
      confirmButtonColor: "#1E9FF2",
      confirmButtonText: "Sim, pode salvar!",
      cancelButtonText: "Não, cancele!",
      closeOnConfirm: true,
      closeOnCancel: false
    }, function (isConfirm) {
      if (isConfirm) {
        $('#cadempresa').submit();
      } else {
        swal("Cancelado", "Operação cancelada! Dados não gravados", "error");
      }
    });
  });

  $('#usuario_login').blur(function () {
    var usuario = $(this).val();
    $.ajax({
      type: "POST",
      url: base_url + 'Configuracoes/Usuario/UsuarioVerificar',
      data: {
        'usuario': usuario,
        csrf_token: $('#crsf_token').val()
      },
      dataType: 'json',
      success: function (data) {
        if (data.length > 0) {
          if ($('#usuario_id').val() != "") {
            if ($('#usuario_id').val() != data[0].ID_USUARIO) {
              swal({
                title: "Usuário encontrado!",
                text: "O usuário informado já existe na base de dados, deseja editá-lo?",
                type: "warning",
                showCancelButton: true,
                confirmButtonColor: "#1E9FF2",
                confirmButtonText: "Sim, desejo editar!",
                cancelButtonText: "Não, cancele!",
                closeOnConfirm: true,
                closeOnCancel: false
              }, function (isConfirm) {
                if (isConfirm) {
                  window.location.replace(base_url + "Configuracoes/Usuario/usuarioEditar/" + btoa(data[0].ID_USUARIO));
                } else {
                  swal("Cancelado", "Operação cancelada!", "error");
                  $('#usuario_login').val("");
                }
              });
            }
          } else {
            swal({
              title: "Usuário encontrado!",
              text: "O usuário informado já existe na base de dados, deseja editá-lo?",
              type: "warning",
              showCancelButton: true,
              confirmButtonColor: "#1E9FF2",
              confirmButtonText: "Sim, desejo editar!",
              cancelButtonText: "Não, cancele!",
              closeOnConfirm: true,
              closeOnCancel: false
            }, function (isConfirm) {
              if (isConfirm) {
                window.location.replace(base_url + "Configuracoes/Usuario/usuarioEditar/" + btoa(data[0].ID_USUARIO));
              } else {
                swal("Cancelado", "Operação cancelada!", "error");
                $('#usuario_login').val("");
              }
            });
          }
        }
      }
    });
  });

  /** Limpa e gera pesquisa */
  $('#limpafrmpesquisa').click(function () {
    $("#frm_pesquisa")[0].reset();
    $('#frm_pesquisa input').val(""); //coloca todos valores de todos inputs do form como vazio
    $(":checkbox").prop('checked', false);
    $(':checkbox').find('checked').remove();
  });
  $('#enviafrmpesquisa').click(function () {
    $("#frm_pesquisa")[0].submit();
  });
};
