/* Funções da tabela Configuracoes/Funcionario */
window.onload = function () {
  var table = $('#lotes').DataTable({
    "language": {
      "sEmptyTable": "Nenhum registro encontrado",
      "sInfo": "Mostrando de _START_ até _END_ de _TOTAL_ registros",
      "sInfoEmpty": "Mostrando 0 até 0 de 0 registros",
      "sInfoFiltered": "(Filtrados de _MAX_ registros)",
      "sInfoPostFix": "",
      "sInfoThousands": ".",
      "sLengthMenu": "_MENU_ resultados por página",
      "sLoadingRecords": "Carregando...",
      "sProcessing": "Processando...",
      "sZeroRecords": "Nenhum registro encontrado",
      "sSearch": "Pesquisar",
      "oPaginate": {
        "sNext": "Próximo",
        "sPrevious": "Anterior",
        "sFirst": "Primeiro",
        "sLast": "Último"
      },
      "oAria": {
        "sSortAscending": ": Ordenar colunas de forma ascendente",
        "sSortDescending": ": Ordenar colunas de forma descendente"
      }
    },
    scrollX: true,
    pageLength: 100
  });

  $('#lotes tbody').on('click', 'tr', function () {
    $(this).toggleClass('selected');
  });

  $('#gravar_lote').click(function () {
    swal({
      title: "Deseja salvar?",
      text: "Certifique-se de ter verificado todos os dados antes de efetuar a ação!",
      type: "warning",
      showCancelButton: true,
      confirmButtonColor: "#1E9FF2",
      confirmButtonText: "Sim, pode salvar!",
      cancelButtonText: "Não, cancele!",
      closeOnConfirm: true,
      closeOnCancel: false
    }, function (isConfirm) {
      if (isConfirm) {
        $('#frmLote_cadastro').submit();
      } else {
        swal("Cancelado", "Operação cancelada! Dados não gravados", "error");
      }
    });
  });

  /** Limpa e gera pesquisa */
  $('#limpafrmpesquisa').click(function () {
    $("#frm_pesquisa")[0].reset();
    $('#frm_pesquisa input').val(""); //coloca todos valores de todos inputs do form como vazio
    $(":checkbox").prop('checked', false);
    $(':checkbox').find('checked').remove();
  });
  $('#enviafrmpesquisa').click(function () {
    $("#frm_pesquisa")[0].submit();
  });

  Dropzone.options.myDropzone = {
    init: function () {
      this.on("addedfile", function (file) {
        // Create the remove button
        var removeButton = Dropzone.createElement("<button class='btn btn-sm btn-block'>Remove file</button>");

        // Capture the Dropzone instance as closure.
        var _this = this;

        // Listen to the click event
        removeButton.addEventListener("click", function (e) {
          // Make sure the button click doesn't submit the form:
          e.preventDefault();
          e.stopPropagation();

          // Remove the file preview.
          _this.removeFile(file);
          // If you want to the delete the file on the server as well,
          // you can do the AJAX request here.
        });

        // Add the button to the file preview element.
        file.previewElement.appendChild(removeButton);
      });
    }
  }

  $('.mix-grid').mixitup();
};
