/* Funções da tabela Configuracoes/Funcionario */
window.onload = function () {
  var base_url = window.location.origin + "/";
  var table = $('#pedidos').DataTable({
    "language": {
      "sEmptyTable": "Nenhum registro encontrado",
      "sInfo": "Mostrando de _START_ até _END_ de _TOTAL_ registros",
      "sInfoEmpty": "Mostrando 0 até 0 de 0 registros",
      "sInfoFiltered": "(Filtrados de _MAX_ registros)",
      "sInfoPostFix": "",
      "sInfoThousands": ".",
      "sLengthMenu": "_MENU_ resultados por página",
      "sLoadingRecords": "Carregando...",
      "sProcessing": "Processando...",
      "sZeroRecords": "Nenhum registro encontrado",
      "sSearch": "Pesquisar",
      "oPaginate": {
        "sNext": "Próximo",
        "sPrevious": "Anterior",
        "sFirst": "Primeiro",
        "sLast": "Último"
      },
      "oAria": {
        "sSortAscending": ": Ordenar colunas de forma ascendente",
        "sSortDescending": ": Ordenar colunas de forma descendente"
      }
    },
    "pageLength": 50,
    scrollX: true
  });


  $('#pedidos button').click(function () {
    var classe = $(this).attr('class');
    if (classe == "btn btn-danger btn-list-icon excluir_pedido") {
      $('#id_pedido').val($(this).attr('id'));
      var idPedido = $('#id_pedido').val();
    }
    swal({
        title: "Deseja excluir?",
        text: "Certifique-se de ter verificado todos os dados antes de efetuar a ação!",
        type: "warning",
        showCancelButton: true,
        confirmButtonColor: "#1E9FF2",
        confirmButtonText: "Sim, pode excluir!",
        cancelButtonText: "Não, cancele!",
        closeOnConfirm: true,
        closeOnCancel: false
      },
      function (isConfirm) {
        if (isConfirm) {
          $.ajax({
            type: "POST",
            url: base_url + 'Milhagens/Pedidos/excluirPedido',
            data: {
              'idPedido': idPedido
            },
            dataType: 'json',
            success: function (data) {
              if (data.msg == "sucesso") {
                swal({
                  title: "Sucesso",
                  type: "success",
                  confirmButtonText: "Ok",
                  text: "Ação realizada!",
                }, function () {
                  location.reload();
                });
              } else if (data.msg == "erro") {
                swal("Erro", "Erro ao realizar a ação!", "error");
              }
            }
          });
        } else {
          swal("Cancelado", "Operação cancelada! Dados não gravados", "error");
        }

      }
    );
  });


  $(".aprovar").change(function () {
    if ($(".aprovar").is(':checked')) {
      var classe = $(this).attr('class');
      if (classe == "aprovar") {
        $('#id_pedido').val($(this).attr('id'));
        $('#pontos_usuario').val($(this).attr('value'));
        var idPedido = $('#id_pedido').val();
        var pontos = $('#pontos_usuario').val();
        pontos = pontos.split('-');
        var pontos_usuario = pontos[0];
        pontos_usuario = parseFloat(pontos_usuario);
        var pontos_produto = pontos[1];
        pontos_produto = parseFloat(pontos_produto);
        var diferenca = pontos_usuario - pontos_produto;
        var idUsuario = $('#id_usuario').val();
      }
      if (pontos_produto > pontos_usuario) {
        swal("Erro", "Esse parceiro não possui pontos suficientes", "error");
      } else {
        swal({
          title: "Deseja salvar?",
          text: "Certifique-se de ter verificado todos os dados antes de efetuar a ação!",
          type: "warning",
          showCancelButton: true,
          confirmButtonColor: "#1E9FF2",
          confirmButtonText: "Sim, pode salvar!",
          cancelButtonText: "Não, cancele!",
          closeOnConfirm: true,
          closeOnCancel: false
        }, function (isConfirm) {
          if (isConfirm) {
            $.ajax({
              type: "POST",
              url: base_url + 'Milhagens/Pedidos/aprovarPedido',
              data: {
                'idPedido': idPedido,
                'idUsuario': idUsuario,
                'diferenca': diferenca
              },
              dataType: 'json',
              success: function (data) {
                if (data.msg == "sucesso") {
                  swal({
                    title: "Sucesso",
                    type: "success",
                    confirmButtonText: "Ok",
                    text: "Ação realizada! Liberado para envio ao parceiro!",
                  }, function () {
                    location.reload();
                  });
                } else if (data.msg == "erro") {
                  swal("Erro", "Erro ao realizar a ação!", "error");
                }
              }
            });
          } else {
            swal("Cancelado", "Operação cancelada! Dados não gravados", "error");
          }
        });
      }
    }
  });

};
