<?php namespace App\Models\Administrativo;

use CodeIgniter\Model;

class PessoasModel extends Model{

    public function __construct(){
        $this->db      = \Config\Database::connect();
        $this->builder = $this->db->table('CAD_PESSOAS');
        $this->session = \Config\Services::session();
        $this->usuario = $this->session->get('dadoslogin');
    }

    function getPessoas(){
        $this->builder->orderBy('NOME_PESSOA');
        return $this->builder->get();
        
    }

    function getPessoasID($id){
        $this->builder->where('ID_PESSOA', $id);
        //return $builder->get()->getRow();
        return $this->builder->get()->getRow();
    }

    function setPessoas($dados){
        $builder = $this->db->table('CAD_PESSOAS');
        $builder->insert($dados);
        $id = $this->db->insertID();
        sys_log($this->usuario['ID_USUARIO'], "Inserção de dados ID: ".$id."", "CAD_PESSOAS");
        return $id;
    }

    function updatePessoas($dados){
        $builder = $this->db->table('CAD_PESSOAS');
        $builder->where('ID_PESSOA', $dados['ID_PESSOA']);
        $builder->update($dados);
        sys_log($this->usuario['ID_USUARIO'], "Atualização de dados ID: ".$dados['ID_PESSOA']."", "CAD_PESSOAS");
        return $this->db->affectedRows();
    }

    function deletarPessoas($idpessoas){   
        $this->builder->where('ID_PESSOA', $idpessoas);
        $resultado = $this->builder->get()->getRow();
        $this->builder->where('ID_PESSOA', $idpessoas)->delete();  
    
        
    }
    function pessoasVerificar($idenditidade){
        $builder = $this->db->table('CAD_PESSOAS');
        $builder->select('ID_PESSOA');
        $builder->where('DOCUMENTO_PESSOA', $idenditidade);
        return $builder->get()->getResultArray();
        
    }

    function pessoasVendedor($id){
        $builder = $this->db->table('CAD_PESSOAS');
        $builder->select('BANCO_AGENCIA, BANCO_CONTA, BANCO_CIDADE, NOME_IPAGAMENTO');
        $builder->where('ID_PESSOA', $id);
        return $builder->get()->getResultArray();
        
    }
    
    
}
?>