<?php namespace App\Controllers\Administrativo;

 use App\Models\Administrativo\CategoriaModel;
 use CodeIgniter\Controller;
 use App\Libraries\Auth;
 
 class Categorias extends Controller
 {

	public function __construct(){
        $this->session = \Config\Services::session();
        $this->usuario = $this->session->get('dadoslogin');
        if($this->usuario == null){
            return redirect()->to('/Admin');
        }
        $this->categoriaModel = new CategoriaModel();
        $this->auth = new Auth();
        helper('complementos'); 
	}

	public function categoriaConsultar(){
        if($this->auth->CheckAuth(9)){
        $dados['resultados'] = $this->categoriaModel->getCategoria();
        echo view('Commons/header');	
        echo view('Commons/navbartop');
        echo view('Commons/navbarleft', getBarMenu($this->usuario));
        echo view('Administrativo/Categoria/categoria', $dados);
        echo view('Commons/footer');
        }else{
            return redirect()->to('/Acesso');
        }
	}

    public function categoriaEditar($id=""){
        if($this->auth->CheckAuth(11)){
            $dados['categoria'] = $this->categoriaModel->getCategoriaID(base64_decode($id));
            echo view('Commons/header');
            echo view('Commons/navbartop');
            echo view('Commons/navbarleft', getBarMenu($this->usuario));
            echo view('Administrativo/Categoria/cad_categoria', $dados);
            echo view('Commons/footer');
        }else{
            return redirect()->to('/Acesso');
        }
    }
    
            public function categoriaExcluir($id=""){
                if($this->auth->CheckAuth(12)){
                $this->categoriaModel->categoriaDeletar(base64_decode($id));
                return redirect()->to('/Administrativo/Categorias/categoriaConsultar?tipo_msg=sucesso&msg=Ação realizada!');
                                                }
            }
        
            public function categoriaInserir(){
                if($this->auth->CheckAuth(10)){
                $dados = array();
                $id = $this->request->getPost('id_categoria');
                if($id == ""){
                    $dados['NOME_CATEGORIA'] = $this->request->getPost('nome_categoria');
                    $dados['CAMINHO_IMAGEM'] = $this->caminhoimage();
                   /* $dados['USUARIO'] = $this->request->getPost('usuario_login');
                    $dados['SENHA'] = sha1(preg_replace('/[^[:alnum:]_]/', '',$this->request->getPost('usuario_senha'))); 
                    $dados['EMAIL'] = $this->request->getPost('usuario_email');
                    $dados['TELEFONE'] = $this->request->getPost('usuario_telefone');
                    $dados['ATIVO'] = $this->request->getPost('usuario_status');*/
                    
                    if($this->categoriaModel->setCategoria($dados)){
                        $this->salvarimage();
                        return redirect()->to('/Administrativo/Categorias/categoriaConsultar?tipo_msg=sucesso&msg=Ação realizada!');
                    }else{
                        return redirect()->to('/Administrativo/Categorias/categoriaConsultar?tipo_msg=erro&msg=Erro ao realizar ação!');
                    }
                }else{
                    $dados['ID_CATEGORIA'] = $this->request->getPost('id_categoria');
                    $dados['NOME_CATEGORIA'] = $this->request->getPost('nome_categoria');
                    $img = $this->request->getFile('images');
                    if ($img != ""){
                    $dados['CAMINHO_IMAGEM'] = $this->caminhoimage();
                    }
                   /* $dados['NOME'] = $this->request->getPost('usuario_nome');
                    $dados['USUARIO'] = $this->request->getPost('usuario_login');
                    $dados['EMAIL'] = $this->request->getPost('usuario_email');
                    $dados['TELEFONE'] = $this->request->getPost('usuario_telefone');
                    $dados['ATIVO'] = $this->request->getPost('usuario_status');*/
        
                    
                    
                    if($this->categoriaModel->updateCategoria($dados)){
                        $this->salvarimage();
                        return redirect()->to('/Administrativo/Categorias/categoriaConsultar?tipo_msg=sucesso&msg=Ação realizada!');
                    }else{
                        return redirect()->to('/Administrativo/Categorias/categoriaConsultar?tipo_msg=erro&msg=Erro ao realizar ação!');
                    }
                }
                    }
            }

            public function salvarimage()
            {
                $img = $this->request->getFile('images');
               if ($img!=""){
                $img->move('./images');
               }
            
            }
    
            public function caminhoimage()
            {
                $img = $this->request->getFile('images');
                $caminho = '/images/'. $img->GetName();
                return $caminho;
            }
        
        
        
        
}
