<?php namespace App\Models\Administrativo;

use CodeIgniter\Model;

class QrcodeModel extends Model{

    protected $table = 'CAD_QRCODE_LINK';

    public function __construct(){
        $this->db      = \Config\Database::connect();
        $this->builder = $this->db->table('CAD_QRCODE_LINK');
        $this->session = \Config\Services::session();
        $this->usuario = $this->session->get('dadoslogin');
    }

    function getQrcode(){
        return $this->builder->get();
        
    }
    function getQrcodeID($id){
        $this->builder->where('ID_QRCODE', $id);
        //return $builder->get()->getRow();
        return $this->builder->get()->getRow();
    }

    function updateQrcode($dados){
        $builder = $this->db->table('CAD_QRCODE_LINK');
        $builder->where('ID_QRCODE', $dados['ID_QRCODE']);
        $builder->update($dados);
        sys_log($this->usuario['ID_USUARIO'], "Atualização de dados ID: ".$dados['ID_QRCODE']."", "CAD_QRCODE_LINK");
        return $this->db->affectedRows();
    }


    function qrcodeDeletar($idqr){   
        $builder = $this->db->table('CAD_QRCODE_LINK');
        $builder->where('ID_QRCODE', $idqr);
        $resultado = $builder->get()->getRow();
        $caminho = $resultado->NOME_QRCODE;
        $path_to_file = '../public/'.$caminho.'.png';
        $builder->where('ID_QRCODE', $idqr)->delete();
      /*  if(unlink($path_to_file)) {
            
        echo 'deleted successfully';
        
}else{
    
}*/

    
    }

    function qrcodeSalvar($dados){
        $builder = $this->db->table('CAD_QRCODE_LINK');
        $builder->insert($dados);
        $id = $this->db->insertID();
        sys_log($this->usuario['ID_USUARIO'], "Inserção de dados ID: ".$id."", "CAD_CATEGORIA");
        return $id;
    }




}