<?php namespace App\Controllers\Configuracoes;

use CodeIgniter\Controller;
use App\Libraries\Auth;
use App\Models\Configuracoes\EmpresaModel;

class Empresa extends Controller
{

	public function __construct(){
        $this->empresaModel = new EmpresaModel();
        $this->session = \Config\Services::session();
        $this->auth = new Auth();
        $this->usuario = $this->session->get('dadoslogin');
        if($this->usuario == null){
            header('Location: '.base_url());
            exit(); 
        
        }
        helper('complementos'); 
    }

	public function empresaConsultar($id=1)
	{
        if($this->auth->CheckAuth(33)){
        $dados['empresa'] = $this->empresaModel->getEmpresaID($id);
        echo view('Commons/header');	
        echo view('Commons/navbartop');
        echo view('Commons/navbarleft', getBarMenu($this->usuario));
        echo view('Configuracoes/Empresa/empresa',$dados);
        echo view('Commons/footer');	

        }else{
            return redirect()->to('/Acesso');
        
        }
       
    }

    public function empresaInserir(){
        if($this->auth->CheckAuth(34)){

        $dados = array();
        $id = $this->request->getPost('id_empresa');
        if($id == ""){
            $dados['NOME_EMPRESA'] = $this->request->getPost('nome_empresa');
            $dados['COR_PRIMARIA'] = $this->request->getPost('cor_primaria');
            $dados['COR_SECUNDARIA'] = $this->request->getPost('cor_secundaria');
            $dados['DESC_EMPRESA'] = $this->request->getPost('desc_empresa');
            $dados['TELEFONE_EMPRESA'] = $this->request->getPost('telefone_empresa');
            $dados['CNPJ_EMPRESA'] = $this->request->getPost('cnpj_empresa');
            $dados['IE_EMPRESA'] = $this->request->getPost('ie_empresa');
            $dados['WHATSAPP_EMPRESA'] = $this->request->getPost('whatsapp_empresa');
            $dados['EMAIL_EMPRESA'] = $this->request->getPost('email_empresa');
            $dados['ENDERECO_EMPRESA'] = $this->request->getPost('endereco_empresa');
            $img = $this->request->getFile('images');
            if ($img != ""){
            $dados['CAMINHO_IMAGEM'] = $this->caminhoimage();
            }
           /* $dados['USUARIO'] = $this->request->getPost('usuario_login');
            $dados['SENHA'] = sha1(preg_replace('/[^[:alnum:]_]/', '',$this->request->getPost('usuario_senha'))); 
            $dados['EMAIL'] = $this->request->getPost('usuario_email');
            $dados['TELEFONE'] = $this->request->getPost('usuario_telefone');
            $dados['ATIVO'] = $this->request->getPost('usuario_status');*/
            
            if($this->empresaModel->salvarEmpresa($dados)){
                $this->salvarimage();
                return redirect()->to('/Configuracoes/Empresa/empresaConsultar?tipo_msg=sucesso&msg=Ação realizada!');
                
            }else{
                return redirect()->to('/Configuracoes/Empresa/empresaConsultar?tipo_msg=erro&msg=Erro ao realizar ação!');
            }
        }else{
            $dados['ID_EMPRESA'] = $this->request->getPost('id_empresa');
            $dados['NOME_EMPRESA'] = $this->request->getPost('nome_empresa');
            $dados['COR_PRIMARIA'] = $this->request->getPost('cor_primaria');
            $dados['COR_SECUNDARIA'] = $this->request->getPost('cor_secundaria');
            $dados['DESC_EMPRESA'] = $this->request->getPost('desc_empresa');
            $dados['CNPJ_EMPRESA'] = $this->request->getPost('cnpj_empresa');
            $dados['IE_EMPRESA'] = $this->request->getPost('ie_empresa');
            $dados['TELEFONE_EMPRESA'] = $this->request->getPost('telefone_empresa');
            $dados['WHATSAPP_EMPRESA'] = $this->request->getPost('whatsapp_empresa');
            $dados['EMAIL_EMPRESA'] = $this->request->getPost('email_empresa');
            $dados['ENDERECO_EMPRESA'] = $this->request->getPost('endereco_empresa');
            $img = $this->request->getFile('images');
            if ($img != ""){
               // $this->delEmpresa($dados['ID_EMPRESA'] );
            $dados['CAMINHO_IMAGEM'] = $this->caminhoimage();
            }
           /* $dados['NOME'] = $this->request->getPost('usuario_nome');
            $dados['USUARIO'] = $this->request->getPost('usuario_login');
            $dados['EMAIL'] = $this->request->getPost('usuario_email');
            $dados['TELEFONE'] = $this->request->getPost('usuario_telefone');
            $dados['ATIVO'] = $this->request->getPost('usuario_status');*/

            
            
            if($this->empresaModel->updateEmpresa($dados)){
                $this->salvarimage();
                return redirect()->to('/Configuracoes/Empresa/empresaConsultar?tipo_msg=sucesso&msg=Ação realizada!');
                
            }else{
                return redirect()->to('/Configuracoes/Empresa/empresaConsultar?tipo_msg=erro&msg=Erro ao realizar ação!');
            }
        
        
        
        }

    } else{
        return redirect()->to('/Acesso');
    
    }  
    }

    public function salvarimage()
    {
        $img = $this->request->getFile('images');
       if ($img!=""){
        $img->move('./images');
       }
    
    }

    public function caminhoimage()
    {
        $img = $this->request->getFile('images');
        $caminho = '/images/'. $img->GetName();
        return $caminho;
    }

    public function delEmpresa($id=""){
        $this->empresaModel->empresaDeletar($id);
        //return redirect()->to('/Configuracoes/Empresa');
}
    

	//--------------------------------------------------------------------
}
