function remover(id) {
    swal({
      title: "Deseja remover?",
      text: "Certifique-se de ter verificado todos os dados antes de efetuar a ação!",
      type: "warning",
      showCancelButton: true,
      confirmButtonColor: "#1E9FF2",
      confirmButtonText: "Sim, pode remover!",
      cancelButtonText: "Não, cancele!",
      closeOnConfirm: true,
      closeOnCancel: false
    }, function (isConfirm) {
      if (isConfirm) {
        window.location.assign("removerLinha/"+btoa(id));
      } else {
        swal("Cancelado", "Operação cancelada! Dados não gravados", "error");
      }
    });
  };

window.onload = function() {
    window.location.origin, $("#log").DataTable({
        dom: 'Bfrtip',
        buttons: [
            {
                extend: 'print',
                exportOptions: {
                    columns: [1,2,3,4,5,6,7,8]
                }
            },
            {
                extend: 'excelHtml5',
                exportOptions: {
                    columns: [1,2,3,4,5,6,7,8]
                }
            },
            {
                extend: 'pdfHtml5',
                exportOptions: {
                    columns: [1,2,3,4,5,6,7,8]
                }
            }
        ],
        language: {
            sEmptyTable: "Nenhum registro encontrado",
            sInfo: "Mostrando de _START_ até _END_ de _TOTAL_ registros",
            sInfoEmpty: "Mostrando 0 até 0 de 0 registros",
            sInfoFiltered: "(Filtrados de _MAX_ registros)",
            sInfoPostFix: "",
            sInfoThousands: ".",
            sLengthMenu: "_MENU_ resultados por página",
            sLoadingRecords: "Carregando...",
            sProcessing: "Processando...",
            sZeroRecords: "Nenhum registro encontrado",
            sSearch: "Pesquisar",
            oPaginate: {
                sNext: "Próximo",
                sPrevious: "Anterior",
                sFirst: "Primeiro",
                sLast: "Último"
            },
            oAria: {
                sSortAscending: ": Ordenar colunas de forma ascendente",
                sSortDescending: ": Ordenar colunas de forma descendente"
            }
        },
        pageLength: 100,
        scrollX: !0,
        "order": [[ 0, "desc" ]]
    });
    $("#log tbody").on("click", "tr", function() {
        $(this).toggleClass("selected")
    }), $("#limpafrmpesquisa").click(function() {
        $("#frm_pesquisa")[0].reset(), $("#frm_pesquisa input").val(""), $(":checkbox").prop("checked", !1), $(":checkbox").find("checked").remove()
    }), $("#enviafrmpesquisa").click(function() {
        $("#frm_pesquisa")[0].submit()
    })
    if($("#filtro_parceiro").val() != ""){
        document.title = $("#filtro_parceiro option:selected").html();
    }

    
};