/* Funções da tabela Configuracoes/Funcionario */
window.onload = function () {
  var table = $('#parcerias').DataTable({
    "language": {
      "sEmptyTable": "Nenhum registro encontrado",
      "sInfo": "Mostrando de _START_ até _END_ de _TOTAL_ registros",
      "sInfoEmpty": "Mostrando 0 até 0 de 0 registros",
      "sInfoFiltered": "(Filtrados de _MAX_ registros)",
      "sInfoPostFix": "",
      "sInfoThousands": ".",
      "sLengthMenu": "_MENU_ resultados por página",
      "sLoadingRecords": "Carregando...",
      "sProcessing": "Processando...",
      "sZeroRecords": "Nenhum registro encontrado",
      "sSearch": "Pesquisar",
      "oPaginate": {
        "sNext": "Próximo",
        "sPrevious": "Anterior",
        "sFirst": "Primeiro",
        "sLast": "Último"
      },
      "oAria": {
        "sSortAscending": ": Ordenar colunas de forma ascendente",
        "sSortDescending": ": Ordenar colunas de forma descendente"
      }
    },
    "order": [
			[2, "asc"]
		],
    scrollX: true
  });

  $(".maskdinheiro").maskMoney({

		prefix: 'R$ ',

		allowNegative: true,

		thousands: '',

		affixesStay: false

  });

  $(".maskpercentual").maskMoney({

		suffix: '% ',

		allowNegative: true,

		thousands: '',

		affixesStay: false

  });

  //Verifica se o valor incial é menor que o maior valor final ja cadastrado
  $("#valor_de").change(function(){
    var maior_valor_ate = parseFloat($("#maior_valor_ate").val());
    var valor_de       = parseFloat($(this).val());
    if(valor_de <= maior_valor_ate){
      swal({
        title: 'Erro!',
        type: "error",
        text: 'Valor inicial é Inválido!',
      });
      $('#gravar_meta').prop('disabled', true);
    }else{
      $('#gravar_meta').prop('disabled', false);
    }
  })

  //Verifica se o valor final é maior que o inicial
  $("#valor_ate").change(function(){
    var valor_de = parseFloat($("#valor_de").val());
    var valor_ate       = parseFloat($(this).val());
    if(valor_ate <= valor_de){
      swal({
        title: 'Erro!',
        type: "error",
        text: 'Valor final é Inválido!',
      });
      $('#gravar_meta').prop('disabled', true);
    }else{
      $('#gravar_meta').prop('disabled', false);
    }
  })


  $('#gravar_meta').click(function () {
    swal({
      title: "Deseja salvar?",
      text: "Certifique-se de ter verificado todos os dados antes de efetuar a ação!",
      type: "warning",
      showCancelButton: true,
      confirmButtonColor: "#1E9FF2",
      confirmButtonText: "Sim, pode salvar!",
      cancelButtonText: "Não, cancele!",
      closeOnConfirm: true,
      closeOnCancel: false
    }, function (isConfirm) {
      if (isConfirm) {
        $('#frmMetas_cadastro').submit();
      } else {
        swal("Cancelado", "Operação cancelada! Dados não gravados", "error");
      }
    });
  });

  $('#remover_metas').click(function () {
    swal({
      title: "Deseja salvar?",
      text: "Caso confirme essa ação, toda a tabela será deletada!",
      type: "warning",
      showCancelButton: true,
      confirmButtonColor: "#1E9FF2",
      confirmButtonText: "Sim, pode salvar!",
      cancelButtonText: "Não, cancele!",
      closeOnConfirm: true,
      closeOnCancel: false
    }, function (isConfirm) {
      if (isConfirm) {
        $.ajax({
          type: "POST",
          url: base_url + 'Cadastros/Metas/metasRemover',
          dataType: 'json',
          success: function (data) {
            if (data == 0) {
              swal({
                title: "Sucesso",
                type: "success",
                confirmButtonText: "Ok",
                text: "Ação realizada, tabela excluída!",
              }, function () {
                location.reload();
              });
              $('#gravar_meta').prop('disabled', true);
            }else{
              swal({
                title: "Erro",
                type: "error",
                confirmButtonText: "Ok",
                text: "Erro ao realizar essa ação!",
              }, function () {
                location.reload();
              });
            }
          }
        });
      } else {
        swal("Cancelado", "Operação cancelada! Dados não gravados", "error");
      }
    });
  });


  //Verifica se percentual existe
  $('#percentual').blur(function () {
    var percentual = $(this).val();
		$.ajax({
			type: "POST",
			url: base_url + 'Cadastros/Metas/percentualVerificar',
			data: {
				'percentual': percentual
			},
			dataType: 'json',
			success: function (data) {
				if (data.length > 0) {
					swal({
            title: 'Erro!',
            type: "error",
            text: 'Percentual ja existe!',
          });
          $('#gravar_meta').prop('disabled', true);
				}else{
          $('#gravar_meta').prop('disabled', false);
        }
			}
		});
	});
};
