<?php namespace App\Controllers\Administrativo;

 use App\Models\Administrativo\CategoriaModel;
 use App\Models\Administrativo\PessoasModel;
 use App\Models\Administrativo\ContratosModel;
 use CodeIgniter\Controller;
 use App\Libraries\Auth;
 
 class Comissoes extends Controller
 {

	public function __construct(){
        $this->session = \Config\Services::session();
        $this->usuario = $this->session->get('dadoslogin');
        if($this->usuario == null){
            return redirect()->to('/Login');
        }
        $this->pessoasModel = new PessoasModel();
        $this->contratosModel = new ContratosModel();
        $this->auth = new Auth();
        helper('complementos'); 
        
    }

    public function comissoesConsultar(){
        if($this->auth->CheckAuth(13)){
            $dados = array();
            $datahoje = date('Y-m-d');
            $datahoje = explode("-", $datahoje);
            $mes = $datahoje[1];
            $ano = $datahoje[0];
            if($this->request->getPost('log_dt_inicial')==null || $this->request->getPost('log_dt_inicial')==""){
                $dt_inicial = $ano.'-'.$mes.'-01';
            }else{
                $dt_inicial = inverterData($this->request->getPost('log_dt_inicial'));
            }
            if($this->request->getPost('log_dt_final')==null || $this->request->getPost('log_dt_final')==""){
                $dt_final = $ano.'-'.$mes.'-31';
            }else{
                $dt_final = inverterData($this->request->getPost('log_dt_final'));
            }

            $dados['resultados'] = $this->contratosModel->getComissoes($dt_inicial, $dt_final, $this->request->getPost('filtro_parceiro')); //Busca no BD todos as pagamentos e salva no array $dados na posição resultados.
            $dados['pessoas'] = $this->pessoasModel->getPessoas();
            echo view('Commons/header');	
            echo view('Commons/navbartop');
            echo view('Commons/navbarleft', getBarMenu($this->usuario));	
            echo view('Administrativo/Comissoes/comissoes', $dados);
            echo view('Commons/footer');
            var_dump($dados['resultados']);
        }else{
            return redirect()->to('/Acesso');
        }
    }
}
