<?php namespace App\Controllers\Administrativo;

 use App\Models\Administrativo\ContratosModel;
 use App\Models\Administrativo\PessoasModel;
 use App\Models\Administrativo\ArmazensModel;
 use App\Models\Administrativo\ModalidadesModel;
 use App\Models\Administrativo\TransportesModel;
 use App\Models\Administrativo\IpagamentosModel;
 use App\Models\Configuracoes\EmpresaModel;
 use CodeIgniter\Controller;
 use App\Libraries\Auth;
 
 class Contratos extends Controller
 {

	public function __construct(){
        $this->session = \Config\Services::session();
        $this->usuario = $this->session->get('dadoslogin');
        if($this->usuario == null){
            header('Location: '.base_url());
            exit(); 
        }
        $this->contratosModel = new ContratosModel();
        $this->pessoasModel = new PessoasModel();
        $this->armazensModel = new ArmazensModel();
        $this->modalidadesModel = new modalidadesModel();
        $this->transportesModel = new transportesModel();
        $this->ipagamentosModel = new IpagamentosModel();
        $this->empresaModel = new EmpresaModel();
        
        $this->auth = new Auth();
        helper('complementos'); 
	}

	public function contratosConsultar(){
        if($this->auth->CheckAuth(9)){
        $dados['contratos'] = $this->contratosModel->getContratos();
        $dados['pessoas'] = $this->pessoasModel->getPessoas();
        echo view('Commons/header');	
        echo view('Commons/navbartop');
        echo view('Commons/navbarleft', getBarMenu($this->usuario));
        echo view('Administrativo/Contratos/contratos', $dados);
        echo view('Commons/footer');
        }else{
            return redirect()->to('/Acesso');
        }
	}
    public function contratos($id=""){
        echo view('Commons/header');
        echo view('Administrativo/Contratos/imp_contrato');
        echo view('Commons/footer');
    }

    public function contratosEditar($id=""){
        if($this->auth->CheckAuth(11)){
            $dados['contrato'] = $this->contratosModel->getContratosID(base64_decode($id));
            $dados['pessoas'] = $this->pessoasModel->getPessoas();
            $dados['armazens'] = $this->armazensModel->getArmazens();
            $dados['modalidades'] = $this->modalidadesModel->getModalidades();
            $dados['transportes'] = $this->transportesModel->getTransportes();
            $dados['ipagamentos'] = $this->ipagamentosModel->getIpagamentos();
            echo view('Commons/header');
            echo view('Commons/navbartop');
            echo view('Commons/navbarleft', getBarMenu($this->usuario));
            echo view('Administrativo/Contratos/cad_contratos', $dados);
            echo view('Commons/footer');
        }else{
            return redirect()->to('/Acesso');
        }
    }
    
            public function contratosExcluir($id=""){
                if($this->auth->CheckAuth(12)){
                $this->contratosModel->deletarContratos(base64_decode($id));
                return redirect()->to('/Administrativo/Contratos/contratosConsultar?tipo_msg=sucesso&msg=Ação realizada!');
                                                }
            }

            public function contratosImprimir($id=""){
                if($this->auth->CheckAuth(11)){
                    $dados['empresa'] = $this->empresaModel->getEmpresaID("1");
                    $dados['contrato'] = $this->contratosModel->contratosImprimir(base64_decode($id));
                     //$result = $this->contratosModel->contratosImprimir(base64_decode($id));;
                    echo view('Administrativo/Contratos/imp_contrato', $dados);
                    //echo $result->ID_CONTRATO;
                }else{
                    return redirect()->to('/Acesso');
                }
            }
        
            public function contratosInserir(){
                if($this->auth->CheckAuth(10)){
                $dados = array();
                $id = $this->request->getPost('id_contrato');
                if($id == ""){
                    $dados['DATA_CONTRATO'] = $this->request->getPost('data_contrato');
                    $dados['CORRETOR_CONTRATO'] = $this->request->getPost('corretor');
                    $dados['NUM_COMPRADOR'] = $this->request->getPost('num_comprador');
                    $dados['FK_ID_COMPRADOR'] = $this->request->getPost('select_comprador');
                    $dados['FK_ID_VENDEDOR'] = $this->request->getPost('select_vendedor');
                    $dados['FK_ID_ARMAZEM_RT'] = $this->request->getPost('select_armazem_rt');
                    $dados['FK_ID_ARMAZEM_ET'] = $this->request->getPost('select_armazem_et');
                    $dados['FK_ID_MODALIDADE'] = $this->request->getPost('select_modalidade');
                    $dados['FK_ID_TRANSPORTE'] = $this->request->getPost('select_transporte');
                    $dados['FK_ID_IPAGAMENTO'] = $this->request->getPost('ipagamento');
                   // $dados['FK_ID_IPGAMENTOS'] = $this->request->getPost('select_ipagamentos');
                   $dados['TAMANHO_SACA'] = $this->request->getPost('tamanho_saca');
                   $dados['QUANTIDADE_SACA'] = $this->request->getPost('quantidade_saca');
                   $dados['PRECO_SACA'] = $this->request->getPost('preco_saca');
                   $valortotal= str_replace('R$', '', $this->request->getPost('valort_saca'));
                   $valortotal = str_replace('r$', '',$valortotal);
                   $dados['VALOR_TOTAL_SACA'] = $valortotal;
                   $dados['CORRETAGEM_VENDEDOR'] = $this->request->getPost('corretagem_vendedor');
                   $dados['VALOR_CVENDEDOR'] = $this->request->getPost('valor_cvendedor');
                   $dados['CORRETAGEM_COMPRADOR'] = $this->request->getPost('corretagem_comprador');
                   $dados['VALOR_CCOMPRADOR'] = $this->request->getPost('valor_ccomprador');
                   $dados['DESCRICAO_CONTRATO'] = $this->request->getPost('descricao_contrato');
                   $dados['OBS_CONTRATO'] = $this->request->getPost('obs_contrato');
                   $dados['BANCO'] = $this->request->getPost('banco_vendedor');
                   $dados['AGENCIA'] = $this->request->getPost('agencia_vendedor');
                   $dados['CONTA'] = $this->request->getPost('conta_vendedor');
                   $dados['CIDADE_BANCO'] = $this->request->getPost('cidadeagencia_vendedor');
                   $dados['POSTO'] = $this->request->getPost('posto_contrato');
                   $dados['RETIRA'] = $this->request->getPost('retira_contrato');
                   /* $dados['USUARIO'] = $this->request->getPost('usuario_login');
                    $dados['SENHA'] = sha1(preg_replace('/[^[:alnum:]_]/', '',$this->request->getPost('usuario_senha'))); 
                    $dados['EMAIL'] = $this->request->getPost('usuario_email');
                    $dados['TELEFONE'] = $this->request->getPost('usuario_telefone');
                    $dados['ATIVO'] = $this->request->getPost('usuario_status');*/
                    
                    if($this->contratosModel->setContratos($dados)){
                       
                        return redirect()->to('/Administrativo/Contratos/contratosConsultar?tipo_msg=sucesso&msg=Ação realizada!');
                    }else{
                        return redirect()->to('/Administrativo/Contratos/contratosConsultar?tipo_msg=erro&msg=Erro ao realizar ação!');
                    }
                }else{
                    $dados['ID_CONTRATO'] = $this->request->getPost('id_contrato');
                    $dados['DATA_CONTRATO'] = $this->request->getPost('data_contrato');
                    $dados['CORRETOR_CONTRATO'] = $this->request->getPost('corretor');
                    $dados['NUM_COMPRADOR'] = $this->request->getPost('num_comprador');
                    $dados['FK_ID_COMPRADOR'] = $this->request->getPost('select_comprador');
                    $dados['FK_ID_VENDEDOR'] = $this->request->getPost('select_vendedor');
                    $dados['FK_ID_ARMAZEM_RT'] = $this->request->getPost('select_armazem_rt');
                    $dados['FK_ID_ARMAZEM_ET'] = $this->request->getPost('select_armazem_et');
                    $dados['FK_ID_MODALIDADE'] = $this->request->getPost('select_modalidade');
                    $dados['FK_ID_TRANSPORTE'] = $this->request->getPost('select_transporte');
                    $dados['FK_ID_IPAGAMENTO'] = $this->request->getPost('ipagamento');
                   // $dados['FK_ID_IPGAMENTOS'] = $this->request->getPost('select_ipagamentos');
                   $dados['TAMANHO_SACA'] = $this->request->getPost('tamanho_saca');
                   $dados['QUANTIDADE_SACA'] = $this->request->getPost('quantidade_saca');
                   $dados['PRECO_SACA'] = $this->request->getPost('preco_saca');
                   $valortotal= str_replace('R$', '', $this->request->getPost('valort_saca'));
                   $valortotal = str_replace('r$', '',$valortotal);
                   $dados['VALOR_TOTAL_SACA'] = $valortotal;
                   $dados['CORRETAGEM_VENDEDOR'] = $this->request->getPost('corretagem_vendedor');
                   $dados['VALOR_CVENDEDOR'] = $this->request->getPost('valor_cvendedor');
                   $dados['CORRETAGEM_COMPRADOR'] = $this->request->getPost('corretagem_comprador');
                   $dados['VALOR_CCOMPRADOR'] = $this->request->getPost('valor_ccomprador');
                   $dados['DESCRICAO_CONTRATO'] = $this->request->getPost('descricao_contrato');
                   $dados['OBS_CONTRATO'] = $this->request->getPost('obs_contrato');
                   $dados['BANCO'] = $this->request->getPost('banco_vendedor');
                   $dados['AGENCIA'] = $this->request->getPost('agencia_vendedor');
                   $dados['CONTA'] = $this->request->getPost('conta_vendedor');
                   $dados['CIDADE_BANCO'] = $this->request->getPost('cidadeagencia_vendedor');
                   $dados['POSTO'] = $this->request->getPost('posto_contrato');
                   $dados['RETIRA'] = $this->request->getPost('retira_contrato');

                    
                   /* $dados['NOME'] = $this->request->getPost('usuario_nome');
                    $dados['USUARIO'] = $this->request->getPost('usuario_login');
                    $dados['EMAIL'] = $this->request->getPost('usuario_email');
                    $dados['TELEFONE'] = $this->request->getPost('usuario_telefone');
                    $dados['ATIVO'] = $this->request->getPost('usuario_status');*/
        
                    
                    
                    if($this->contratosModel->updateContratos($dados)){
                       
                        return redirect()->to('/Administrativo/Contratos/contratosConsultar?tipo_msg=sucesso&msg=Ação realizada!');
                    }else{
                        return redirect()->to('/Administrativo/Contratos/contratosConsultar?tipo_msg=erro&msg=Erro ao realizar ação!');
                    }
                }
                    }
            }

            

        
        
        
        
}
