/* Funções da tabela Configuracoes/Funcionario */
window.onload = function () {
  var base_url = window.location.origin + "/";
  var table = $('#orcamento').DataTable({
    "language": {
      "sEmptyTable": "Nenhum registro encontrado",
      "sInfo": "Mostrando de _START_ até _END_ de _TOTAL_ registros",
      "sInfoEmpty": "Mostrando 0 até 0 de 0 registros",
      "sInfoFiltered": "(Filtrados de _MAX_ registros)",
      "sInfoPostFix": "",
      "sInfoThousands": ".",
      "sLengthMenu": "_MENU_ resultados por página",
      "sLoadingRecords": "Carregando...",
      "sProcessing": "Processando...",
      "sZeroRecords": "Nenhum registro encontrado",
      "sSearch": "Pesquisar",
      "oPaginate": {
        "sNext": "Próximo",
        "sPrevious": "Anterior",
        "sFirst": "Primeiro",
        "sLast": "Último"
      },
      "oAria": {
        "sSortAscending": ": Ordenar colunas de forma ascendente",
        "sSortDescending": ": Ordenar colunas de forma descendente"
      }
    },
    "pageLength": 50,
    scrollX: true
  });

  $('#clientes tbody').on('click', 'tr', function () {
    $(this).toggleClass('selected');
  });

  $('#gravar_solicitacao').click(function () {
    $('#frmSolicitacoes_cadastro').submit();
  });

  /** Design da tela */

  /* Esconde os elementos da tela */

  $('.fisica').hide();
  $('.juridica').hide();

  $('#solicitacoes_tipo').on('change', function () {
    var tipo = $(this).val();
    if (tipo == "F") {
      /** Exibindo campos pessoa física */
      $('.juridica').hide();
      $('.fisica').show();
      /* Adicionando regras de validação*/
      $(".juridica").prop("disabled", true);
      $(".fisica").prop("disabled", false);
    }
    if (tipo == "J") {
      /** Exibindo campos pessoa jurídica */
      $('.fisica').hide();
      $('.juridica').show();
      /* Adicionando regras de validação*/
      $(".fisica").prop("disabled", true);
      $(".juridica").prop("disabled", false);
    }

    if (tipo == "") {
      $('.fisica').hide();
      $('.juridica').hide();
    }
  });

  /**Carregamento campos em edição obs:não precisa de click */

  var tipo = $('#solicitacoes_tipo').val();
  if (tipo == "F") {
    /** Exibindo campos pessoa física */
    $('.juridica').hide();
    $('.fisica').show();
    /* Adicionando regras de validação*/
    $(".juridica").prop("disabled", true);
    $(".fisica").prop("disabled", false);
  }
  if (tipo == "J") {
    /** Exibindo campos pessoa jurídica */
    $('.fisica').hide();
    $('.juridica').show();
    /* Adicionando regras de validação*/
    $(".fisica").prop("disabled", true);
    $(".juridica").prop("disabled", false);
  }

  /** Webservice VIACEP */

  $("#solicitacoes_cep").blur(function () {
    //Nova variável "cep" somente com dígitos.
    var cep = $(this).val().replace(/\D/g, '');

    //Verifica se campo cep possui valor informado.
    if (cep != "") {

      //Expressão regular para validar o CEP.
      var validacep = /^[0-9]{8}$/;

      //Valida o formato do CEP.
      if (validacep.test(cep)) {

        //Preenche os campos com "..." enquanto consulta webservice.
        $("#solicitacoes_logradouro").val("...");
        $("#solicitacoes_bairro").val("...");
        $("#solicitacoes_cidade").val("...");
        $("#solicitacoes_uf").val("...");
        $("#solicitacoes_ibge").val("...");

        //Consulta o webservice viacep.com.br/
        $.getJSON("https://viacep.com.br/ws/" + cep + "/json/?callback=?", function (dados) {

          if (!("erro" in dados)) {
            //Atualiza os campos com os valores da consulta.
            $("#solicitacoes_logradouro").val(dados.logradouro);
            $("#solicitacoes_bairro").val(dados.bairro);
            $("#solicitacoes_cidade").val(dados.localidade);
            $("#solicitacoes_uf").val(dados.uf);
            $("#solicitacoes_ibge").val(dados.ibge);
          } //end if.
          else {
            //CEP pesquisado não foi encontrado.
            swal("Erro!",
              "CEP não encontrado!")
          }
        });
      } //end if.
      else {
        //cep é inválido.
        swal("Erro!",
          "CEP inválido!")
      }
    } //end if.
  });


  /** Editar CPF e CNPJ se já houver na base de dados 
  $('#solicitacoes_cpf').blur(function () {
    var cpf = $(this).val();
    $.ajax({
      type: "POST",
      url: base_url + 'Cadastros/Clientes/clientesVerificarCPF_CNPJ',
      data: {
        'cpf_cnpj': cpf,
      },
      dataType: 'json',
      success: function (data) {
        if (data.length > 0) {
          if ($('#solicitacoes_id').val() != "") {
            if ($('#solicitacoes_id').val() != data[0].ID_PESSOA) {
              swal({
                title: "CPF Encontrado",
                text: "O CPF informado já existe na base de dados, deseja editá-lo?",
                type: "warning",
                showCancelButton: true,
                confirmButtonColor: "#1E9FF2",
                confirmButtonText: "Sim, desejo editar!",
                cancelButtonText: "Não, cancele!",
                closeOnConfirm: true,
                closeOnCancel: false
              }, function (isConfirm) {
                if (isConfirm) {
                  window.location.replace(base_url + "Cadastros/Clientes/clientesEditar?id=" + btoa(data[0].ID_PESSOA));
                } else {
                  swal("Cancelado", "Operação cancelada!", "error");
                  $('#solicitacoes_cpf').val("");
                }
              });
            }
          } else {
            swal({
              title: "CPF Encontrado",
              text: "O CPF informado já existe na base de dados, deseja editá-lo?",
              type: "warning",
              showCancelButton: true,
              confirmButtonColor: "#1E9FF2",
              confirmButtonText: "Sim, desejo editar!",
              cancelButtonText: "Não, cancele!",
              closeOnConfirm: true,
              closeOnCancel: false
            }, function (isConfirm) {
              if (isConfirm) {
                window.location.replace(base_url + "Cadastros/Clientes/clientesEditar?id=" + btoa(data[0].ID_PESSOA));
              } else {
                swal("Cancelado", "Operação cancelada!", "error");
                $('#solicitacoes_cpf').val("");
              }
            });
          }
        }
      }
    });
  });*/

  $('#solicitacoes_cnpj').blur(function () {
    var cnpj = $(this).val().replace(/\D/g, '');
    $.ajax({
      type: "POST",
      url: base_url + 'Cadastros/Clientes/clientesVerficarCPF_CNPJ',
      data: {
        'cpf_cnpj': cnpj,
      },
      dataType: 'json',
      success: function (data) {
        if (data.length > 0) {
          if ($('#solicitacoes_id').val() != "") {
            if ($('#solicitacoes_id').val() != data[0].ID_PESSOA) {
              swal({
                title: "CNPJ Encontrado",
                text: "O CNPJ informado já existe na base de dados, deseja editá-lo?",
                type: "warning",
                showCancelButton: true,
                confirmButtonColor: "#1E9FF2",
                confirmButtonText: "Sim, desejo editar!",
                cancelButtonText: "Não, cancele!",
                closeOnConfirm: true,
                closeOnCancel: false
              }, function (isConfirm) {
                if (isConfirm) {
                  window.location.replace(base_url + "Cadastros/Clientes/clientesEditar?id=" + btoa(data[0].ID_PESSOA));
                } else {
                  swal("Cancelado", "Operação cancelada!", "error");
                  $('#solicitacoes_cnpj').val("");
                }
              });
            } else {

            }
          } else {
            swal({
              title: "CNPJ Encontrado",
              text: "O CNPJ informado já existe na base de dados, deseja editá-lo?",
              type: "warning",
              showCancelButton: true,
              confirmButtonColor: "#1E9FF2",
              confirmButtonText: "Sim, desejo editar!",
              cancelButtonText: "Não, cancele!",
              closeOnConfirm: true,
              closeOnCancel: false
            }, function (isConfirm) {
              if (isConfirm) {
                window.location.replace(base_url + "Cadastros/Clientes/clientesEditar?id=" + btoa(data[0].ID_PESSOA));
              } else {
                swal("Cancelado", "Operação cancelada!", "error");
                $('#solicitacoes_cnpj').val("");
              }
            });
          }
        }
      }
    });
  });

  $('#solicitacoes_razao_social').focus(function (event) {
    var cnpj = $('#solicitacoes_cnpj').val().replace(/\D/g, '');
    $.ajax({
      url: 'https://www.receitaws.com.br/v1/cnpj/' + cnpj + '',
      type: 'GET',
      crossDomain: true,
      dataType: 'jsonp',
      success: function (dados) {
        $('#solicitacoes_razao_social').val(dados.nome);
        $('#solicitacoes_nome_fantasia').val(dados.fantasia);
        $('#solicitacoes_cidade').val(dados.municipio);
        $('#solicitacoes_uf').val(dados.uf);
        $('#solicitacoes_logradouro').val(dados.logradouro);
        $('#solicitacoes_numero').val(dados.numero);
        $('#solicitacoes_bairro').val(dados.bairro);
        $('#solicitacoes_cep').val(dados.cep);
        var cep = dados.cep.replace(/\D/g, '');
        $.getJSON("https://viacep.com.br/ws/" + cep + "/json/?callback=?", function (data) {

          if (!("erro" in data)) {
            //Atualiza os campos com os valores da consulta.
            $("#solicitacoes_ibge").val(data.ibge);
          } //end if.
          else {
            //CEP pesquisado não foi encontrado.
            swal("Erro!",
              "CEP não encontrado!")
          }
        });
        $.getJSON("https://maps.googleapis.com/maps/api/geocode/json?address=" + $('#solicitacoes_logradouro').val() + "," + $('#solicitacoes_numero').val() + $('#solicitacoes_cidade').val() + "-" + $('#solicitacoes_uf').val() + "," + $('#solicitacoes_cep').val() + "&key=AIzaSyBxukFXx6DjX_hNm0_Lo_YEo1fZy63Tleo", function (dados) {

          if (!("erro" in dados)) {
            deleteMarkers();
            addMarker(dados.results[0].geometry.location);
            addGeocode(dados.results[0].geometry.location.lat, dados.results[0].geometry.location.lng);
          }
        });
        $('#solicitacoes_email').val(dados.email);
        $('#solicitacoes_telefone01').val(dados.telefone);
      }
    });
  });

  /** Limpa e gera pesquisa */
  $('#limpafrmpesquisa').click(function () {
    $("#frm_pesquisa")[0].reset();
    $('#frm_pesquisa input').val(""); //coloca todos valores de todos inputs do form como vazio
    $(":checkbox").prop('checked', false);
    $(':checkbox').find('checked').remove();
  });
  $('#enviafrmpesquisa').click(function () {
    $("#frm_pesquisa")[0].submit();
  });

  $('#solicitacoes_cep').blur(function () {
    if ($('#solicitacoes_cep').val() != '') {
      $.getJSON("https://maps.googleapis.com/maps/api/geocode/json?address=" + $('#solicitacoes_logradouro').val() + "," + $('#solicitacoes_numero').val() + $('#solicitacoes_cidade').val() + "-" + $('#solicitacoes_uf').val() + "," + $('#solicitacoes_cep').val() + "&key=AIzaSyBxukFXx6DjX_hNm0_Lo_YEo1fZy63Tleo", function (dados) {

        if (!("erro" in dados)) {
          deleteMarkers();
          addMarker(dados.results[0].geometry.location);
          addGeocode(dados.results[0].geometry.location.lat, dados.results[0].geometry.location.lng);
        }
      });
    }
  });

  $('#solicitacoes_cidade').blur(function (event) {
    if ($('#solicitacoes_cidade').val() != '') {
      $.getJSON("https://maps.googleapis.com/maps/api/geocode/json?address=" + $('#solicitacoes_logradouro').val() + "," + $('#solicitacoes_numero').val() + $('#solicitacoes_cidade').val() + "-" + $('#solicitacoes_uf').val() + "," + $('#solicitacoes_cep').val() + "&key=AIzaSyBxukFXx6DjX_hNm0_Lo_YEo1fZy63Tleo", function (dados) {

        if (!("erro" in dados)) {
          deleteMarkers();
          addMarker(dados.results[0].geometry.location);
          addGeocode(dados.results[0].geometry.location.lat, dados.results[0].geometry.location.lng);
        }
      });
    }
  });

  $('#solicitacoes_uf').blur(function (event) {
    if ($('#solicitacoes_uf').val() != '') {
      $.getJSON("https://maps.googleapis.com/maps/api/geocode/json?address=" + $('#solicitacoes_logradouro').val() + "," + $('#solicitacoes_numero').val() + $('#solicitacoes_cidade').val() + "-" + $('#solicitacoes_uf').val() + "," + $('#solicitacoes_cep').val() + "&key=AIzaSyBxukFXx6DjX_hNm0_Lo_YEo1fZy63Tleo", function (dados) {

        if (!("erro" in dados)) {
          deleteMarkers();
          addMarker(dados.results[0].geometry.location);
          addGeocode(dados.results[0].geometry.location.lat, dados.results[0].geometry.location.lng);
        }
      });
    }
  });

  $('#solicitacoes_logradouro').blur(function (event) {
    if ($('#solicitacoes_logradouro').val() != '') {
      $.getJSON("https://maps.googleapis.com/maps/api/geocode/json?address=" + $('#solicitacoes_logradouro').val() + "," + $('#solicitacoes_numero').val() + $('#solicitacoes_cidade').val() + "-" + $('#solicitacoes_uf').val() + "," + $('#solicitacoes_cep').val() + "&key=AIzaSyBxukFXx6DjX_hNm0_Lo_YEo1fZy63Tleo", function (dados) {

        if (!("erro" in dados)) {
          deleteMarkers();
          addMarker(dados.results[0].geometry.location);
          addGeocode(dados.results[0].geometry.location.lat, dados.results[0].geometry.location.lng);
        }
      });
    }
  });

  $('#solicitacoes_numero').blur(function (event) {
    if ($('#solicitacoes_numero').val() != '') {
      $.getJSON("https://maps.googleapis.com/maps/api/geocode/json?address=" + $('#solicitacoes_logradouro').val() + "," + $('#solicitacoes_numero').val() + $('#solicitacoes_cidade').val() + "-" + $('#solicitacoes_uf').val() + "," + $('#solicitacoes_cep').val() + "&key=AIzaSyBxukFXx6DjX_hNm0_Lo_YEo1fZy63Tleo", function (dados) {

        if (!("erro" in dados)) {
          deleteMarkers();
          addMarker(dados.results[0].geometry.location);
          addGeocode(dados.results[0].geometry.location.lat, dados.results[0].geometry.location.lng);
        }
      });
    }
  });

  var geocode = $('#geocode').val();

  if (geocode != null && geocode != "") {
    $.getJSON("https://maps.googleapis.com/maps/api/geocode/json?latlng=" + geocode + "&key=AIzaSyBxukFXx6DjX_hNm0_Lo_YEo1fZy63Tleo", function (dados) {

      if (!("erro" in dados)) {
        //Adicionar marcador no maps
        addMarker(dados.results[0].geometry.location);
      } //end if.
      else {
        alert('erro ao carregar mapa');
        //CEP pesquisado não foi encontrado.
      }
    });
  }

  $('#gravar_info').click(function () {
    $.ajax({
      type: "POST",
      url: base_url + 'Orcamento/Solicitacoes/setInformacoesProj',
      data: {
        'id': $('#id').val(),
        'msg': $('#solicitacoes_detalhes').val(),
      },
      dataType: 'json',
      success: function (data) {
        if (data.msg == "sucesso") {
          swal({
            title: "Sucesso",
            type: "success",
            confirmButtonText: "Ok",
            text: "Informação salva!",
          });
        } else {
          swal("Erro", "Erro ao salvar informação!", "error");
        }
      }
    });
  });

  Dropzone.options.myDropzone = {
    init: function () {
      this.on("addedfile", function (file) {
        // Create the remove button
        var removeButton = Dropzone.createElement("<button class='btn btn-sm btn-block'>Remove file</button>");

        // Capture the Dropzone instance as closure.
        var _this = this;

        // Listen to the click event
        removeButton.addEventListener("click", function (e) {
          // Make sure the button click doesn't submit the form:
          e.preventDefault();
          e.stopPropagation();

          // Remove the file preview.
          _this.removeFile(file);
          // If you want to the delete the file on the server as well,
          // you can do the AJAX request here.
        });

        // Add the button to the file preview element.
        file.previewElement.appendChild(removeButton);
      });
    }
  }
};
